#!/usr/bin/env python
# -*- coding: utf-8 -*-

import sys, getpass, socket, os
import base64
from pyeole.ihm import print_line
from pyeole.ansiprint import print_orange, print_red
from creole.client import CreoleClient
from collections import OrderedDict


try:
    from zephir.zephir_conf.zephir_conf import adresse_zephir
except:
    client = CreoleClient()
    adresse_zephir = client.get_creole('nom_domaine_machine')
from zephir.lib_zephir import convert
from zephir.lib_zephir import xmlrpclib
from zephir.lib_zephir import EoleProxy
from zephir.lib_zephir import TransportEole
from zephir.lib_zephir import flushed_input


def display_help():
    print("Sauvegarde une cle ssh d'un utilisateur dans Zephir")
    print("{} [utilisateur] [--key chemin_de_la_clé]".format(sys.argv[0]))


def argparser():
    arglen = len(sys.argv)
    if arglen == 1:
        return None, None
    if sys.argv[1] in ['-h', '--help']:
        display_help()
        sys.exit(0)

    user = sys.argv[1]

    if sys.argv[2] in ['-k', '--key']:
        keypath = sys.argv[3]
        return user, keypath

    return user, None


def main():
    # import des fonctions communes de Zéphir client
    user, keypath = argparser()

    authentified, proxy = get_pwd(adresse_zephir, 7080)
    if authentified == False:
        sys.exit(1)

    if user is None :
        user = flushed_input("Utilisateur : ")

    if keypath is None :
        keypath = flushed_input("Chemin de la clé ssh : ")

    keyssh = None
    with open(keypath) as f:
        keyssh = f.read()

    clef_ssh = base64.encodestring(keyssh).decode()
    os.chdir("/etc/postgresql/")
    cmd="""sudo -u postgres psql -c "update users set cle='{}' where login='{}';" zephir""".format(clef_ssh,user)
    output = os.popen(cmd)
    res = output.read().strip()
    output.close()

    # enregistrement de la clef ssh

    if res == "UPDATE 1":
        print("OK")
        print("Excecuter le script authorize_user_group pour authoriser l'accès de l'utilisateur aux serveurs")
    else:
        print("Erreur : ", str(res))

def get_pwd(addr, port):
    """lecture d'un login/passwd pour l'application zephir
    """
    login_ok = 0
    user = "toto"
    while login_ok == 0 and user != "":
        try:
            # flush de l'entrée standard au cas où l'utilisateur aurait
            # tapé <entrée> pendant l'Upgrade
            termios.tcflush(sys.stdin, termios.TCIOFLUSH)
        except:
            pass
        user = flushed_input("Entrez votre login zephir (rien pour sortir) : ")
        if user != "":
            passwd = getpass.getpass("Mot de passe zephir pour %s : " % user)
            # création du proxy avec zephir
            proxy = EoleProxy("https://%s:%s@%s:%s" % (user, passwd, addr, port), transport=TransportEole())
            login_ok = 1
            try:
                res = convert(proxy.get_permissions(user))
            except xmlrpclib.ProtocolError:
                login_ok = 0
                print_line("\n Erreur d'authentification \n")
        else:
            return False, "! Abandon de la procédure !"
    return True, proxy


if __name__ == '__main__':
    main()



