#-*-coding:utf-8-*-
###########################################################################
# Eole NG - 2007
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
#
# config.py
#
# Configuration du gestionnaire de base de données
#
###########################################################################
"""
    Configuration du gestionnaire de base de données
"""
from os import path
from creole.client import CreoleClient

LOGLEVEL = 0
LOGFILE = "/var/log/databases.log"
# Clé obligatoire pour la conf de mise à jour
CONF_KEYS = ["filenames", "db", "host"]

APP_DIRNAME = '/usr/share/eole/applications'
UPDATE_DIRNAME = path.join(APP_DIRNAME, 'updates')
PWD_DIRNAME = path.join(APP_DIRNAME, 'passwords')
GEN_DIRNAME = path.join(APP_DIRNAME, 'gen')
ROOT_USERNAME = 'root'

dico_creole = CreoleClient()
if dico_creole.get_creole('mode_conteneur_actif') == 'oui':
    SOURCE_HOST = dico_creole.get_creole('adresse_ip_br0')
    HOST = dico_creole.get_creole('container_ip_mysql')
else:
    SOURCE_HOST = HOST = 'localhost'
CONTAINER_PATH = dico_creole.get_creole('container_path_mysql')
MYSQL_DIR = path.join('/', CONTAINER_PATH, "var/lib/mysql")
MYSQL_SOCK_PATH = '/var/run/mysqld/mysqld.sock'
