#!/usr/bin/env python
# -*- coding: utf-8 -*-
###########################################################################
# Eole NG - 2009
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
#
# mysql_pwd.py
#
# Mise à jour des mots de passe Mysql
#
###########################################################################
"""
Outil de mise à jour des mots de passe mysql
-1-   Modifier tous les mots de passe:
root@scribe:~# mysql_pwd.py <nouveau mot de passe root>
-2-   Juste modifier le mot de passe root
root@scribe:~# mysql_pwd.py <nouveau mot de passe root> toto
-3-   Lancer l'outil de modification
root@scribe:~# mysql_pwd.py
## Réinitialisation des mots de passe Mysql ##

Nouveau mot de passe root mysql : <nouveau mot de passe root>

Voulez-vous que les autres mots de passe soient modifiés (oui/non) ?
"""

import os, sys

from creole.eosfunc import gen_random
from pyeole.process import system_code, system_out
from pyeole.ihm import question_ouinon

from eolesql.log import log_console, log
from eolesql.collect_pwd import get_password_conf
from eolesql.mysqltest import mysql_ok
from eolesql.config import ROOT_USERNAME, HOST, SOURCE_HOST


def modif_pass(fichier, user, attr, mdp, rpass, end_tmpl_string=None):
    """
    @fichier : fichier de conf de l'appli
    @user : utilisateur mysql
    @attr : nom de l'attribut mot de passe dans le fichier de conf
            (template de début de ligne)
    @mdp  : nouveau mot de passe mysql
    @rpass : mot de passe root de mysql
    @end_tmpl_string : template pour la fin de ligne
    """
    # modification du mot de passe mysql
    os.system("""echo \"UPDATE user SET password=PASSWORD('%s')
                        WHERE user='%s';
                    flush  privileges;\" | mysql --password=\"%s\" -h%s mysql""" %
                        (mdp, user, rpass, HOST))
    #print "Mise à jour du fichier %s..." % fichier
    conf_file = open(fichier,"r")
    buffer_in = conf_file.readlines()
    conf_file.close()
    buffer_out = ""
    # on parcourt le fichier
    for line in buffer_in:
        # si la ligne actuelle contient la chaine recherchée
        if line.startswith(attr):
            #print "définition du mot de passe trouvée : "+line.strip()
            buffer_out += attr
            buffer_out += mdp
            if end_tmpl_string != None:
                buffer_out += end_tmpl_string
            else:
                if attr.endswith('"'):
                    # si mot de passe entre guillemets,
                    # ajout du guillemet fermant
                    buffer_out += '"'
                if fichier.endswith('.pl') or fichier.endswith('.pm') \
                                           or fichier.endswith('.php'):
                    buffer_out += ';'
            buffer_out += "\n"
        else:
            # sinon, on recopie la ligne d'origine
            buffer_out += line

    # sauvegarde du fichier de conf
    conf_file = open(fichier, "w")
    conf_file.write(buffer_out)
    conf_file.close()

def mysql_root_passwd(new_pass, default_file='/etc/mysql/debian.cnf'):
    """
    Modifie le mot de passe mysql de l'utilisateur root
    :param new_pass: password to apply
    :type new_pass: `str`
    :param default_file: path to mysql config file
    :type default_file: `str`
    """
    sql_cmd = "UPDATE user SET password=PASSWORD('%s') WHERE user='%s';flush privileges;" % (new_pass, ROOT_USERNAME,)
    remote_cmd = "mysql --defaults-file={0} mysql".format(default_file)
    system_code(remote_cmd.split(), container='mysql', stdin=sql_cmd)
    if HOST not in ['127.0.0.1', 'localhost']:
        sql_cmd = "REPLACE INTO user SET host='%s', user='%s',\
                    password=password('%s'), Select_priv='Y', Insert_priv='Y',\
                    Update_priv='Y', Delete_priv='Y', Create_priv='Y',\
                    Drop_priv='Y', Reload_priv='Y', Shutdown_priv='Y',\
                    Process_priv='Y',  File_priv='Y', Grant_priv='Y',\
                    References_priv='Y', Index_priv='Y', Alter_priv='Y',\
                    Super_priv='Y', Show_db_priv='Y', Create_tmp_table_priv='Y',\
                    Lock_tables_priv='Y', Execute_priv='Y', Repl_slave_priv='Y',\
                    Repl_client_priv='Y', Create_view_priv='Y', Show_view_priv='Y',\
                    Create_routine_priv='Y', Alter_routine_priv='Y',\
                    Create_user_priv='Y', Event_priv='Y', Trigger_priv='Y',\
                    Create_tablespace_priv='Y';\
                    flush privileges;" % (SOURCE_HOST, ROOT_USERNAME, new_pass)
        system_code(remote_cmd.split(), container='mysql', stdin=sql_cmd)


def gen_random_passwds():
    """
        Génère une liste de nouveaux mots de passe aléatoires
    """
    code, out, err = system_out(["/usr/bin/pwgen", "-C"])
    return out.strip().split()

def chmod(conf_dict):
    """
        définit les droits chmod pour le user owner
    """
    chown_cmd = ['/bin/chown', conf_dict['owner'], conf_dict['filename']]
    chmod_cmd = ['/bin/chmod', str(conf_dict['chmod']), conf_dict['filename']]
    container = conf_dict.get('container')
    system_code(chown_cmd, container=container)
    system_code(chmod_cmd, container=container)

def mod_user_password_confs(root_pass, mysql_user, tables, new_pass):
    """
        Effectue la modification complète des mot de passe mysql
        pour l'utilisateur mysql_user
        Préférez mod_user_password ou mod_passwords
    """
    log(" + Modification du mot de passe pour \"%s\" +" % mysql_user)
    for table in tables:
        conf_file = table['filename']
        tmpl_string = table['tmpl_string']
        end_tmpl_string = table.get('end_tmpl_string')
        if os.path.isfile(conf_file):
            if table.get('pre_cmd'):
                os.system(table.get('pre_cmd').replace('NEWPASS', new_pass))
            modif_pass(conf_file, mysql_user, tmpl_string,
                                        new_pass, root_pass, end_tmpl_string)
            if table.get('owner') and table.get('chmod'):
                chmod(table)
            if table.get('post_cmd'):
                os.system(table.get('post_cmd').replace('NEWPASS', new_pass))

def mod_passwords(root_pass):
    """
        Modifie les mots de passe mysql (sauf celui de root)
        :root_pass:mot de passe root
        :username:nom de l'utilisateur dont on change le mot de passe
    """
    modif_pass_dict = get_password_conf()
    # generation de mots de passe
    mdps = gen_random_passwds()
    indice = 0
    for mysql_user, tables in modif_pass_dict.items():
        new_pass = mdps[indice]
        mod_user_password_confs(root_pass, mysql_user, tables, new_pass)
        indice += 1

def mod_user_password(username=None):
    """
        Change le mot de passe de l'utilisateur username ainsi que celui de root
    """
    new_root_pass = gen_random(10)
    mysql_root_passwd(new_root_pass)

    new_pass = gen_random(10)
    modif_pass_tables = get_password_conf().get(username, [])

    mod_user_password_confs(new_root_pass, username, modif_pass_tables, new_pass)

def mod_all_passwords():
    """
        Change tous les mots de passe (root compris)
    """
    new_root_pass = gen_random(10)
    mysql_root_passwd(new_root_pass)
    mod_passwords(new_root_pass)

def main():
    """
        Fonciton d'entrée pour la mise à jour des mots de passe mysql
    """
    ask = False
    modify = True

    # Modification du mot de passe root de mysql
    try:
        new_root_pass = sys.argv[1]
    except:
        ask = True
        new_root_pass = ""
        while len(new_root_pass) < 5:
            if new_root_pass != "":
                print("le mot de passe est trop court (5 caractères au moins)")
            new_root_pass = raw_input("\nNouveau mot de passe root mysql : ")
    mysql_root_passwd(new_root_pass)

    # Modification des mots de passe des autres applications
    if ask == True:
        if question_ouinon('\nVoulez-vous que les autres mots de passe soient modifiés ?') == 'non':
            modify = False
    elif len(sys.argv) == 3:
        modify = False

    if modify == True:
        mod_passwords(new_root_pass)

if __name__ == "__main__":
    log_console("## Réinitialisation des mots de passe Mysql ##")
    mysql_ok()
    main()
