#!/usr/bin/env python
# -*- coding: utf-8 -*-

# Ajout d'une base de données dans Mysql
# EOLE 2.3
# Equipe Eole eole@ac-dijon.fr

import sys
from eolesql.log import log_console
from creole.eosfunc import gen_random
from eolesql.config import ROOT_USERNAME, HOST
from mysql_pwd import mysql_root_passwd
from pyeole.process import system_code
from creole.client import CreoleClient

mysql_code = """CREATE DATABASE %s;
GRANT ALL PRIVILEGES ON %s.* TO %s@%s IDENTIFIED BY '%s';
flush  privileges;
"""

if __name__ == "__main__":

    dico = CreoleClient().get_creole()
    VIRTDISABLED = (dico['mode_conteneur_actif'] == 'non')

    if '-h' in sys.argv or '--help' in sys.argv:
        cmd = "\"dbname\" \"dbuser\" \"dbpass\""
        if not VIRTDISABLED:
            cmd += " [\"container\"]"
        print """Utilisation :

        * Mode interactif :
            %s

        * Mode non interactif
            %s %s
        """ % (sys.argv[0], sys.argv[0], cmd)
        sys.exit()

    if len(sys.argv) == 4 or (not VIRTDISABLED and len(sys.argv) == 5):
        database = sys.argv[1]
        user = sys.argv[2]
        password = sys.argv[3]
        if not VIRTDISABLED and len(sys.argv) == 5:
            container = sys.argv[4]
        else:
            container = "root"
    else:
        database = raw_input("Nom de la base de données à créer : ")
        user = raw_input("Nom de l'utilisateur Mysql administrant la base : ")
        password = raw_input("Mot de passe de l'utilisateur Mysql administrant \
la base : ")
        if not VIRTDISABLED:
            container = raw_input("Nom du conteneur source : ")
        else:
            container = "root"

    # modification du mot de passe root de Mysql
    root_password = gen_random(10)
    mysql_root_passwd(root_password)

    # création de la base et de son utilisateur
    log_console("## Création de la base %s ##" % (database, ))
    if container == 'root':
        container_ip = 'localhost'
    else:
        container_ip = dico.get('container_ip_{0}'.format(container),
                                'localhost')
    code = mysql_code % (database, database, user, container_ip, password)
    system_code(["/usr/bin/mysql", "-p%s" % root_password,
                 "-u%s" % ROOT_USERNAME, "-h%s" % HOST, "mysql"], stdin=code)
