#!/usr/bin/env python
# -*- coding: utf-8 -*-
###########################################################################
# Eole NG - 2009
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
#
# gen_databases.py
#
# Génération de base de données mysql
#
###########################################################################
"""
Outil de génération de base de données
-1- Générer toutes les bases de données:
root@scribe:~# gen_databases.py
-2- Générer juste une base de données :
root@scribe:~# gen_databases.py -u <propriétaire de la base> <nom de la base de données>
"""
import sys, getopt
from os.path import isfile

from creole.eosfunc import gen_random

from eolesql.log import log_console, log
from eolesql.db_layer import DB
from eolesql.collect_gen import load_apps_conf
from eolesql.mysqltest import mysql_ok
from eolesql.db_cmd import dump_sql_file
from eolesql.config import HOST

from mysql_pwd import mysql_root_passwd, mod_all_passwords, mod_user_password

DOC = """
Usage : gen_databases.py [OPTIONS] [DBNAME]
Lance la génération de base de données pour la base DBNAME.
Pour plus d'informations sur le système de génération de base de données eole.
Voir le site officiel : eole.orion-education.fr

Options :
-h --help : Affiche ce message
-u --username : Nom de l'utilisateur d'accès à la base
Aucune autre option n'est supportée à ce jour.

Exemple 1 :
gen_databases.py
génère toutes les base de données en attente

Exemple 2 :
gen_databases.py moodle
génère la base de données moodle

Exemple 3:
gen_databases.py -u monuser matable
génère la base de données matable et met à jour le mot de passe pour monuser
"""

def usage():
    """
        Print la doc dans la ligne de commande
    """
    print DOC

def gen_databases(db_to_gen_dict):
    """
        Génération des bases de données
        une base : {'test':fonction de test,
                    'database' : 'nom de la database sur laquelle pointer(facultatif)',
                    'filenames':'nom des fichiers sql à dumper',
                    'pregen': 'requête sql à éxécuter avant la
                               génération'(facultatif),
                    'postgen': 'requête sql à éxécuter après la
                                génération'(facultatif),
                    }
    """
    new_root_password = gen_random(10)
    mysql_root_passwd(new_root_password)
    db_handler = DB(dict(host=HOST,
                    user='root',
                    passwd=new_root_password))

    #met dans l'ordre alphabétique (#3943)
    app_names = db_to_gen_dict.keys()
    app_names.sort()
    for app_name in app_names:
        db_conf = db_to_gen_dict[app_name]
        database = db_conf.get('database', "")
        if db_conf['test']():
            log_console("# Ajout de la base de données %s" % (app_name,))
            if db_conf.has_key('pregen'):
                log(" + Éxécution de la requête 'pregen'", 2)
                db_conf['pregen'](db_handler)
            if db_conf.has_key('filenames'):
                for filename in db_conf['filenames']:
                    if isfile(filename):
                        log(" + Création de la base de données", 2)
                        dump_sql_file(new_root_password, filename, database, db_conf.get('inject', ''))
                    else:
                        log_console(" - Erreur : Il manque le fichier %s" % (
                                                        filename,))
            else:
                log_console(" - Erreur : Il manque des éléments de \
configuration pour l'ajout de base de données", 1)
            if db_conf.has_key('postgen'):
                log(" + Éxécution de la requête 'postgen'", 2)
                db_conf['postgen'](db_handler)
        else:
            log_console(" + La condition de création de la base %s n'est pas \
satisfaite +" % (app_name,), 1)


def get_option(cmd_line_args):
    """
        Renvoie les options demandées
    """
    try:
        options, arguments = getopt.getopt(cmd_line_args, "u:h",
                                                "username:help")
    except getopt.GetoptError, err:
        log_console(str(err))
        usage()
        sys.exit(2)
    tablename = None
    username = None
    for option, value in options:
        if option in ("-h", "--help"):
            usage()
            sys.exit(0)
        elif option in ("-u", "--username"):
            username = value.strip()
        else:
            log_console("Argument non supporté : \"%s\"" % option)
            usage()
    if arguments: #Si on a spécifié un nom de base de données
        tablename = arguments[0]
        if not username:
            username = tablename
    else: # on ne restreint pas la modification des mots de passe
        username = None
    return username, tablename

def main():
    """
        gère l'appel depuis la ligne de commande
    """
    log_console("## Génération de base de données ##")
    mysql_ok()
    # On charge les configurations pour la génération de tables
    DB_TO_GEN = load_apps_conf()
    # on parse les arguments de la requêtes
    username, tablename = get_option(sys.argv[1:])
    if tablename:
        # on restreint la génération aux tables demandées
        all_keys = DB_TO_GEN.keys()
        try:
            for key in all_keys:
                if key != tablename:
                    DB_TO_GEN.pop(key)
            assert DB_TO_GEN.has_key(tablename)
        except KeyError:
            log_console("Erreur : aucune configuration trouvée pour la \
table \"%s\"" % tablename)
            usage()
            sys.exit(2)
    if DB_TO_GEN:
        gen_databases(DB_TO_GEN)
        if username is not None:
            mod_user_password(username)
        else:
            mod_all_passwords()
    else:
        log(" - Aucune configuration de base de données n'a été trouvée")

if __name__ == '__main__':
    main()
