#-*-coding:utf-8-*-
"""
    fonctions utilisées pour les tests de création des bdd
"""
from os.path import isdir, isfile, join
from eolesql.config import MYSQL_DIR, dico_creole


def db_exists(database):
    """
    vérifie l'existence physique d'une base de données
    """
    return isdir(join(MYSQL_DIR, database)) or isdir(join(MYSQL_DIR, database.lower()))

def table_exists(database, table):
    """
    vérifie l'existence physique d'une table dans une bdd
    """
    return isfile(join(MYSQL_DIR, database, '%s.frm' % table))

def test_var(variable, value='oui'):
    """
    test la valeur d'une variable creole
    """
    return dico_creole.get_creole(variable, 'non') == value
