#-*-coding:utf-8-*-
"""
    fonctions utils pour les appels sql
"""
from pyeole.process import system_code

def dump_sql_file(mysql_root_pwd, filename, database=None, inject=''):
    """
        Dump un fichier .sql dans la base
    """
    mysql_cmd = ['mysql', '--defaults-file=/etc/mysql/debian.cnf']
    if database:
        mysql_cmd += [database]
    sql_code = inject
    sql_code += file(filename).read()
    return system_code(mysql_cmd, stdin=sql_code, container='mysql')

def dump_sql_file2(filename, database=None, default_file='/etc/mysql/debian.cnf'):
    """
        Dump un fichier .sql dans la base
        En utilisant le fichier debian.cnf indiqué
    """
    mysql_cmd = ['mysql', '--defaults-file={}'.format(default_file)]
    if database:
        mysql_cmd += [database]
    sql_code = file(filename).read()
    return system_code(mysql_cmd, stdin=sql_code, container='mysql')
