#-*-coding:utf-8-*-
###########################################################################
# Eole NG - 2007
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
#
# collect_pwd.py
#
# Collecteur d'application demandant la mise à jour d'un mot de passe mysql
#
###########################################################################
"""
    Collecte les configurations des applications
    dont le mot de passe doit être mise à jour
    format de la configuration du .ini

    [application]
    bdd_user=<utilisateur>
    filename=<chemin vers le fichier de conf de l'appli>,...
    template=<template de début de ligne de la configuration
                  du mot de passe ex:'$passwd="'>
    container=<nom du conteneur si nécessaire>

"""
from os.path import isfile, isdir, join, splitext
from os import listdir

from pyeole.dict4ini import DictIni

from eolesql.log import log
from eolesql.config import PWD_DIRNAME, dico_creole

def update_conf_dict(mydict, bdd_user, owner, chmod, filenames, tmpl_str, end_tmpl_str, pre_cmd, post_cmd):
    """
        Update le dictionnaire de configuration des mots de passe à mettre
        à jour
    """
    # écriture dans le dico
    if bdd_user:
        mydict.setdefault(bdd_user, [])
        for filename in filenames:
            conf = dict(filename=filename, owner=owner, chmod=chmod)

            if pre_cmd:
                conf['pre_cmd'] = pre_cmd
            if post_cmd:
                conf['post_cmd'] = post_cmd
            if end_tmpl_str:
                conf['end_tmpl_string'] = end_tmpl_str
            if tmpl_str:
                conf['tmpl_string'] = tmpl_str
                mydict[bdd_user].append(conf)
            else:
                log(" - Erreur : Il manque le template pour l'écriture du mot de passe.")
    else:
        log(" - Erreur : Il manque le nom de l'utilisateur pour la modification du mot \
de passe.")

def parse_ini_file(mydict, inifname):
    """
        Récupère les applications à modifier
    """
    if isfile(inifname):
        inifile = DictIni(inifname)
        for app in inifile:
            if not app[0].startswith('__'): # voir le fonctionnement de DictIni
                myapp = inifile[app[0]]
                log("+ Récupération de la configuration pour : %s" % (app, ), 1)
                bdd_user = myapp.username
                log(" + Utilisateur : %s" % (bdd_user,), 1)
                filenames = myapp.filename
                container = myapp.container
                if container:
                    prefix = dico_creole.get_creole('container_path_%s' % container)
                    if prefix != '':
                        filenames = join(prefix, filenames[1:])
                log(" + Noms de fichier %s" % (filenames,), 1)
                tmpl_str = myapp.template
                log(" + Template : %s" % (tmpl_str,), 1)
                end_tmpl_str = myapp.end_template
                log(" + End_template : %s" % (end_tmpl_str,), 2)
                pre_cmd = myapp.pre_cmd
                post_cmd = myapp.post_cmd
                log(" + pre_cmd: %s, post_cmd: %s" % (pre_cmd, post_cmd), 2)
                owner = myapp.owner
                chmod = myapp.chmod
                if not hasattr(filenames, '__iter__'):
                    filenames = [filenames]
                update_conf_dict(mydict, bdd_user, owner, chmod, filenames,
                                 tmpl_str, end_tmpl_str, pre_cmd, post_cmd)

def get_password_conf(dirname=PWD_DIRNAME):
    """
        Renvoie le dictionnaire de configuration des applications
        dont le mot de passe mysql est à mettre à jour
    """
    mydict = dict()
    for inifile in list_inifiles(dirname):
        log(" + Parsing du fichier %s." % (inifile,), 1)
        parse_ini_file(mydict, inifile)
    log(" + La configuration des mots de passe est : %s" % (mydict,), 1)
    return mydict

def list_inifiles(dirname):
    """
        Renvoie la liste des fichiers .ini du répertoire dirname
    """
    if isdir(dirname):
        return [join(dirname, filename) for filename in listdir(dirname)
                                        if splitext(filename)[1] == '.ini']
    else:
        log(" - Erreur : Le répertoire %s n'existe pas." % dirname)
        return []
