#-*-coding:utf-8-*-
###########################################################################
# Eole NG - 2007
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
#
# collect_gen.py
#
# Collecteur d'application demandant une génération de base de données
#
###########################################################################
"""
    Collecte les configurations des applications
    nécessitant une nouvelle base de données

    une fonction de test : test('')
    une liste de fichier sql à dumper si le test est faux
    une requête sql lancée avant la génération (facultatif)
    une requête sql lancée après la génération (facultatif)
"""
import imp
from os import path, listdir
from traceback import print_exc

from eolesql.log import log
from eolesql.config import GEN_DIRNAME

def get_apps(dirname=GEN_DIRNAME):
    """
        Liste les fichiers .py des applications dont la base est à mettre à
        jour renvoie les chemins vers les ss-rep du rep 'dirname'
    """
    if path.isdir(dirname):
        return [path.splitext(app)[0] for app in listdir(dirname) \
                if path.splitext(app)[1] == '.py' and app != '__init__.py']
    else:
        log(" - Erreur : Le répertoire %s n'existe pas" % (dirname))
        return []

def load_app_conf(py_filename, py_filepath=GEN_DIRNAME):
    """
        charge la configuration pour la génération de la base définie
        dans py_filepath/py_filename
    """
    log(" + Chargement de : %s dans le répertoire : %s" % (
                                    py_filename, py_filepath),
            2)
    filename, pathname, desc = imp.find_module(py_filename, [py_filepath])
    try:
        mymodule = imp.load_module(py_filename, filename, pathname, desc )
        conf_dict = mymodule.conf_dict
    except:
        print_exc()
        log(" - Erreur au chargement de la configuration")
        conf_dict = {}
    filename.close()
    if 'test' not in conf_dict or 'filenames' not in conf_dict:
        log(" - Erreur : Il manque des données pour la configuration de la \
génération de base de données.")
        return {}
    return conf_dict

def load_apps_conf():
    """
        Renvoie le dictionnaire contenant les configurations des bases de
        données à générer
    """
    bdd_to_gen = {}
    conf_files = get_apps(GEN_DIRNAME)
    for app_filename in conf_files:
        conf_dict = load_app_conf(app_filename, GEN_DIRNAME)
        if conf_dict:
            bdd_to_gen[app_filename] = conf_dict
    return bdd_to_gen
