#-*-coding:utf-8-*-
###########################################################################
# Eole NG - 2007
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
#
# collect_update.py
#
# Collecteur d'application
#
###########################################################################
"""
    collecteur des configurations des mises à jour de base de données
"""
import imp
from os import path, listdir

from pyeole.sort import get_sort
from eolesql.log import log
from eolesql.config import UPDATE_DIRNAME, CONF_KEYS, HOST


def get_apps(dirname=UPDATE_DIRNAME):
    """
        Liste les applications dont la base est à mettre à jour
        renvoie les chemins vers les ss-rep du rep UPDATE_DIRNAME
    """
    if path.isdir(dirname):
        return [path.join(dirname, app) for app in listdir(dirname) \
            if path.isdir(path.join(dirname, app))]
    else:
        log(" - Erreur : le répertoire %s n'existe pas" % (dirname))
        return []

def test_app_config(app_path):
    """
        app_path -> True/False
        Teste si tous les fichiers nécessaires (config.py et *.sql) sont
        présents dans la configuration de l'application
    """
    if "config.py" not in listdir(app_path):
        return False, 'config.py'
    elif "__init__.py" not in listdir(app_path):
        return False, "__init__.py"
    else:
        return True

def get_conf_dict(app_path):
    """
        Importe le fichier de configuration et renvoie le dictionnaire
    """
    filename, pathname, desc = imp.find_module("config", [app_path])
    try:
        mymodule = imp.load_module("config", filename, pathname, desc)
        conf_dict = mymodule.conf_dict
    except:
        log(" - Erreur au chargement de la configuration")
        import traceback
        traceback.print_exc()
        conf_dict = {}
    filename.close()
    return conf_dict

def load_app_conf(app_path):
    """
        Charge la configurations d'une application
    """
    test = test_app_config(app_path)
    # ne pas modifier la ligne qui suit
    if test == True:
        conf_dict = get_conf_dict(app_path)

        if 'host' not in conf_dict:
            conf_dict['host'] = HOST
        for key in CONF_KEYS:
            if key not in conf_dict.keys():
                log(" - Il manque la variable \"%s\" dans la configuration \
de l'update de base de données dans : %s." % (key, app_path,))
                return False, ''
        if not hasattr(conf_dict['filenames'], '__iter__'):
            conf_dict['filenames'] = [conf_dict['filenames']]
        return conf_dict['db'], conf_dict
    else:
        log(" - Il manque le fichier %s dans la configuration de l'update \
de base de données dans %s." % (test[1], app_path))
        return False, ''

def load_apps_conf(dirname=UPDATE_DIRNAME):
    """
        Charge les configurations des bases à mettre à jour
    """
    updates_conf = dict()
    sort_by_version = get_sort('version')
    for app_path in get_apps(dirname):
        db_name, app_conf = load_app_conf(app_path)
        if app_conf:
            # si un test d'activation est présent, on le vérifie
            func_test_active = app_conf.get('test_active', None)
            if func_test_active is not None and not func_test_active():
                # on passe cette application
                continue
            updates_conf.setdefault(db_name, []).append(app_conf)
            updates_conf[db_name].sort(sort_by_version)
    return updates_conf
