#-*-coding:utf-8-*-
###########################################################################
# Eole NG - 2007
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
#
# Gestionnaire générique de connexion à une base de données
#
###########################################################################
"""
    Outil de connexion à une base de données
"""
import MySQLdb

class DB(object):
    """
        Gestionnaire de connexion
    """
    def __init__(self, dbinfos={'host':'', 'user':'', 'passwd':'', 'db':''}):
        if '' in dbinfos.values():
            raise Exception("Missing database infos values")
        self.dbinfos = dbinfos
        self.db = None

    def connect_db(self, mysql=False):
        """
            Connecte à la base de données
        """
        if mysql:
            dbinfos = self.dbinfos.copy()
            dbinfos.pop('db')
            self.db = MySQLdb.connection(**dbinfos)
        else:
            self.db = MySQLdb.connection(**self.dbinfos)

    def close_db(self):
        """
            Déconnecte de la base
        """
        if self.db:
            self.db.close()

    def query(self, query_str):
        """
            exécute une requête dans la base
        """
        #print "Requête Mysql (query) : %s" % query_str
        self.connect_db()
        self.db.query(query_str)
        rows = self.db.store_result()
        result = list(rows.fetch_row(0))
        self.close_db()
        return result

    def simple_query(self, query_str):
        """
            exécute une requête dans la base sans résultat
        """
        return self.insert(query_str)

    def insert(self, query_str):
        """
        exécute une requête d'insert dans la base
        """
        self.connect_db()
        self.db.query(query_str)
        self.close_db()
        return True

    def delete(self, query_str):
        """
            Supprime une entrée de la base de données
        """
        return self.insert(query_str)
