#-*-coding:utf-8-*-
###########################################################################
# Eole NG - 2007
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
#
# log.py
#
# Log des gestionnaire de base de données
#
###########################################################################
"""
    Outil de log du gestionnaire de base de données
"""
from .config import LOGLEVEL, LOGFILE

def format_msg(msg):
    """
        transforme le message en string
    """
    if type(msg) != str:
        msg = str(msg)
    return msg

def write_log(msg, level=0):
    """
        écrit le message dans le fichier de log
    """
    if level <= LOGLEVEL:
        logfile = open(LOGFILE, "a")
        logfile.write(msg)
        logfile.write('\n')
        logfile.close()

def log(msg, level=0):
    """
        log msg si loglevel <= DEBUGLEVEL
    """
    format_msg(msg)
    write_log(msg, level)

def log_console(msg, level=0):
    """
        log msg dans les logs et sur la console si loglevel <= DEBUGLEVEL
    """
    msg = format_msg(msg)
    if level <= LOGLEVEL:
        print(msg) # écriture du message vers la console
    write_log(msg)
