#-*-coding:utf-8-*-
"""
    Fonctions de tests pour mysql
"""
import sys
from time import sleep
from pyeole.service import manage_services
from pyeole.process import system_code
from eolesql.config import MYSQL_SOCK_PATH

def sock_exists():
    """
    Vérifie la socket de Mysql est bien présente
    """
    # /!\ il faut tester dans le context /!\
    exists = system_code(['/usr/bin/test', '-e', MYSQL_SOCK_PATH],
                         container='mysql')
    return exists == 0

def mysql_ok():
    """
    vérification du bon fonctionnement de Mysql
    """
    if sock_exists():
        return True
    boucle = 0
    ## (re)demarrage de Mysql
    #ne pas faire de restart si mysql est stoppé, il ne redemarre pas
    manage_services('stop', 'mysql', container='mysql', display='console')
    manage_services('start', 'mysql', container='mysql', display='console')
    while not sock_exists():
        # on attend la mise en place du socket :)
        print("wait")
        sleep(0.5)
        boucle += 1
        if boucle > 30:
            sys.exit("ERREUR : Temps d'attente du socket Mysql dépassé !")
