#!/usr/bin/python3
# -*- coding: utf-8 -*-

# Ajout d'une base de données dans Mysql
# EOLE 2.8
# Equipe Eole eole@ac-dijon.fr

import sys
from eolesql.log import log_console
from pyeole.process import system_code
from creole.client import CreoleClient

MYSQL_CMD = ['mysql', '--defaults-file=/etc/mysql/debian.cnf', 'mysql']
SQL_CODE = """CREATE DATABASE {0};
CREATE USER IF NOT EXISTS '{1}'@'{2}' IDENTIFIED BY '{3}';
GRANT ALL PRIVILEGES ON {0}.* to '{1}'@'{2}';
flush  privileges;
"""

if __name__ == "__main__":

    dico = CreoleClient().get_creole()
    VIRTDISABLED = (dico['mode_conteneur_actif'] == 'non')

    if '-h' in sys.argv or '--help' in sys.argv:
        cmd = "\"dbname\" \"dbuser\" \"dbpass\""
        if not VIRTDISABLED:
            cmd += " [\"container\"]"
        print("""Utilisation :

        * Mode interactif :
            %s

        * Mode non interactif
            %s %s
        """ % (sys.argv[0], sys.argv[0], cmd))
        sys.exit()

    if len(sys.argv) == 4 or (not VIRTDISABLED and len(sys.argv) == 5):
        database = sys.argv[1]
        user = sys.argv[2]
        password = sys.argv[3]
        if not VIRTDISABLED and len(sys.argv) == 5:
            container = sys.argv[4]
        else:
            container = "root"
    else:
        database = input("Nom de la base de données à créer : ")
        user = input("Nom de l'utilisateur Mysql administrant la base : ")
        password = input("Mot de passe de l'utilisateur Mysql administrant \
la base : ")
        if not VIRTDISABLED:
            container = input("Nom du conteneur source : ")
        else:
            container = "root"

    # création de la base et de son utilisateur
    log_console("## Création de la base %s ##" % (database, ))
    if container == 'root':
        container_ip = 'localhost'
    else:
        container_ip = dico.get('container_ip_{0}'.format(container),
                                'localhost')
    code = SQL_CODE.format(database, user, container_ip, password)
    system_code(MYSQL_CMD, stdin=code, container='mysql')
