# -*- coding: utf-8 -*-
"""
Support for era matrix format
"""

import iptc as _iptc

TABLES = ['FILTER', 'MANGLE', 'NAT', 'RAW']

def _update_directive_states(directives):
    with open(_ACTIVE_TAGS, 'r') as active_tags_stream:
        for tag in active_tags_stream.readlines():
            label, state, _, _ = tag.split(',')
            for directive in directives:
                if label == directive.label:
                    directive.set_state(state)


def getdirectives(**kwargs):
    directives = []
    for table in [_iptc.Table(getattr(_iptc.Table, t)) for t in TABLES]:
        for chain in table.chains:
            for rule in chain.rules:
                directives.append({'destination': rule.dst,
                                   'source': rule.src,
                                   'chain': chain.name,
                                   'table': table.name,
                                   'target': rule.target.name,
                                   'match': [m.name for m in rule.matches],
                                   'protocole': rule.protocol,
                                   'in': rule.in_interface,
                                   'out': rule.out_interface})
    return directives
