# -*- coding: utf-8 -*-
"""
Support for era matrix format
"""

import iptc as _iptc
import re as _re

TABLES = ['FILTER', 'MANGLE', 'NAT', 'RAW']

def _update_directive_states(directives):
    with open(_ACTIVE_TAGS, 'r') as active_tags_stream:
        for tag in active_tags_stream.readlines():
            label, state, _, _ = tag.split(',')
            for directive in directives:
                if label == directive.label:
                    directive.set_state(state)


def getdirectives(**kwargs):
    directives = []
    regexp = _re.compile(r"^([0-9A-Za-z]{3}-)([0-9A-Za-z]{3})$")
    for table in [_iptc.Table(getattr(_iptc.Table, t)) for t in TABLES]:
        for chain in table.chains:
            for rule in chain.rules:
                broadcast = False
                ipset = False
                comment = ''
                for match in rule.matches:
                    if match.name == 'state' and match.state == 'RELATED,ESTABLISHED':
                        break
                    if match.name == 'limit':
                        break
                    if match.name == 'pkttype' and match.pkt_type == 'broadcast':
                        broadcast = True
                    if match.name == 'set':
                        ipset = True
                    if match.name == 'comment':
                        comment = match.parameters['comment']
                else:
                    name = rule.target.name
                    if not name in ['netbios-ext', 'icmp-acc'] and not regexp.search(name):
                        # only if -j is not adm-ped
                        if broadcast:
                            destination = 'broadcast'
                        else:
                            destination = rule.dst
                        dport = ','.join([m.dport for m in rule.matches if m.dport])
                        if ipset:
                            name = 'ipset'
                        directives.append({'destination': destination,
                                           'source': rule.src,
                                           'chain': chain.name,
                                           'table': table.name,
                                           'target': name,
                                           'dport': dport,
                                           'protocol': rule.protocol,
                                           'in': rule.in_interface,
                                           'out': rule.out_interface,
                                           'comment': comment})
    return directives
