# -*- coding: utf-8 -*-
"""
Support for era matrix format
"""

from pyeole.process import system_out as _system_out
import argparse as _argparse
import shlex as _shlex
from creole.eosfunc import calc_netmask as _calc_netmask


_TABLES = ['filter', 'mangle', 'nat', 'raw']


_parser = _argparse.ArgumentParser()
_parser.add_argument('-A', '--chain', type=str)
_parser.add_argument('-s', '--source', type=str, default='0.0.0.0/0')
_parser.add_argument('-d', '--destination', type=str, default='0.0.0.0/0')
_parser.add_argument('-i', '--in_', type=str)
_parser.add_argument('-o', '--out', type=str)
_parser.add_argument('-p', '--protocol', type=str, default='ip')
_parser.add_argument('-m', type=str)
_parser.add_argument('--state', type=str)
_parser.add_argument('--dport', type=str, default='')
_parser.add_argument('--tcp-flags', type=str, nargs=2)
_parser.add_argument('--match-set', type=str, nargs=2)
_parser.add_argument('--comment', type=str, default='')
_parser.add_argument('--limit', type=str)
_parser.add_argument('--log-prefix', type=str)
_parser.add_argument('-j', '--target', type=str)
_parser.add_argument('--icmp-type', type=str)
_parser.add_argument('--to-source', type=str)
_parser.add_argument('--to-ports', type=str)


def getdirectives(**kwargs):
    directives = []
    for table in _TABLES:
        rc, out, err = _system_out(['iptables-save', '-t', table])
        if rc != 0:
            raise Exception('cannot extract iptable rules')
        for line in out.strip().split('\n'):
            try:
                if line.startswith('#') or line.startswith('*') or line == 'COMMIT':
                    continue
                if line.startswith(':'):
                    line = line[1:].split(' ')
                    line = f'-A {line[0]} -j {line[1]}'
                nline = _shlex.split(line)
                not_opts = []
                if '!' in nline:
                    for idx, nopt in enumerate(nline.copy()):
                        if nopt == '!':
                            not_opt = nline[idx + 1]
                            if not_opt.startswith('-'):
                                not_opt = not_opt[1:]
                            if not_opt.startswith('-'):
                                not_opt = not_opt[1:]
                            not_opts.append(not_opt)
                            nline.pop(idx)
                args = _parser.parse_args(nline)
                if '-' in args.target:
                    continue
                if not args.in_ and not args.out and 'icmp-acc' not in line and 'netbios-ext' not in line and (table != 'mangle' or 'marquage' not in line):
                    continue
                if args.target == 'LOG':
                    continue
                source = args.source
                if '/' in source:
                    ip, cidr = source.split('/')
                    if cidr == '0':
                        cidr = '0.0.0.0'
                    network = _calc_netmask(cidr)
                    source = f'{ip}/{network}'
                    if 's' in not_opts:
                        source = f'!{source}'
                destination = args.destination
                if '/' in destination:
                    ip, cidr = destination.split('/')
                    if cidr == '0':
                        cidr = '0.0.0.0'
                    network = _calc_netmask(cidr)
                    destination = f'{ip}/{network}'
                    if 'd' in not_opts:
                        destination = f'!{destination}'
                target = args.target
                if args.match_set:
                    target = 'ipset'
                directives.append({'destination': destination,
                                   'source': source,
                                   'chain': args.chain,
                                   'table': table,
                                   'target': target,
                                   'dport': args.dport,
                                   'protocol': args.protocol,
                                   'in': args.in_,
                                   'out': args.out,
                                   'comment': args.comment,
                                   })
            except Exception as err:
                # cannot parse this line
                pass
    return directives
