# -*- coding: UTF-8 -*-
"""tests unitaires du format xml des zones

# FIXME : tester les regles d'utilisation authentifiée générées

"""

import autopath, os

from xml.dom.minidom import parseString, parse
from era.noyau import domparsers
from era.noyau.fwobjects import UserGroup
from era.noyau.initialize import parse_firewall_file
from io import StringIO

def test_parse_user_group():
    """parse une string xml user
    L{era.noyau.domparsers.instantiate_user_group_from_dom}
    """
    USER_XML = """<user_group name="toto" id="15"/>"""
    doc = parseString(USER_XML)
    user = domparsers.instantiate_user_group_from_dom(doc.firstChild)
    assert user.id == "15"
    assert user.name == "toto"

def test_save_user_group():
    """enregistrement xml d'un user
    L{era.noyau.fwobjects.UserGroup.save}
    """
    user = UserGroup("15", "titi")
    fh = StringIO()
    user.save(fh)
    output = fh.getvalue()
    expected = """<user_group name="titi" id="15"/>\n"""
    assert output == expected

def test_parse_model_user_group():
    """test du chargement d'un user_group depuis la matrice
    L{era.noyau.initialize.parse_firewall_file}
    """
    model_file = os.path.join(autopath.HERE, "data", "user_groups.xml")
    fwobjs = parse_firewall_file(model_file)
    flux_list= fwobjs['flux_list']
    assert flux_list[0].up_directives_list()[0].user_group.id == "10"
    assert flux_list[0].up_directives_list()[0].user_group.name == "eleve"
