# -*- coding: UTF-8 -*-
###########################################################################
# 
# Eole NG  
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  http://www.cecill.info/licences/Licence_CeCILL_V2-fr.html
# eole@ac-dijon.fr 
#  
###########################################################################

"""vues en fenêtres splittees de la répartition de qos
c'est un imbriquation de : 

  GtkHPaned
    GtkDrawingArea
...

  GtkHPaned
    GtkDrawingArea

en autant de fois que de zones

"""

import gtk
import pango
import random

import gtk, gtk.glade
import gobject
import ihm_utils
from era.noyau.pool import library_store
from era.noyau.fwobjects import QosClass
from ihm_utils import create_error_dialog

#try: _
#except: _ = str

# largeur totale de la fenetre de partage
WIDTH = 750
# hauteur de la fenetre de partage
HEIGHT = 55

# tout sauf le noir (c'est utilise pour le texte)
COLORS = ['#FF0000', '#ff00f0', '#67D3D7', '#CEBFDC', '#FFFFFF', '#E3AA57', '#21DA37', '#615DAE', '#f2d511']

from decimal import Decimal as dec

def average(value, total=WIDTH):
    "calcul de moyenne (largeur par defaut"
    return str(dec(value) / dec(total) * dec('100') )

def from_percent(value, width=WIDTH):
    """renvoie un entier a partir du pourcentage d'une bande donnee"""
    return int( ( float(value)*width ) / 100 )

class QosShareWindow:
    """Fenêtre de partage de Qos """
    def __init__(self, glade_file):
        self.glade_file = glade_file
        self.glade = gtk.glade.XML(self.glade_file,"bwshare_dialog", "editeur")
        self.bwshare = self.glade.get_widget('bwshare_dialog')
        # self.container_widget = self.glade.get_widget('bwshare_hpaned')
        self.container_widget = self.glade.get_widget('bwshare_alignment')
        self.libelle_widget = self.glade.get_widget('bwshare_libelles_vbox')
        # bande passante pour la qos
        self.upload_entry = self.glade.get_widget('upload_entry')
        self.download_entry = self.glade.get_widget('download_entry')
        self.unactived_qosoption_warning_label = self.glade.get_widget("unactived_qosoption_warning_label")
        # boites de rangement des zones 
        self.zboxes = []
        # largeur par defaut des zones
        self.width = 200
        # largeur totale
        self.total_width = 700
        # les zones de dessins
        self.draws = []
        handlers = {
            'on_bwshare_okbutton_press_event': self.response, 
            'on_bwshare_cancelbutton_press_event': self.close, 
            }
        self.glade.signal_autoconnect(handlers)
        self.set_default_bandwidths()

    def set_default_bandwidths(self):
        """renseigne les valeurs des bandwidth par defaut dans les widgets"""
        self.upload_entry.set_text(str(library_store.upload_bandwidth))
        self.download_entry.set_text(str(library_store.download_bandwidth))

    def show(self):
        """affichage.
        la fenêtre de qos ne doit pas s'ouvrir (pas de répartition de qos si une seule zone)
        """
        if len(self.zones) in (0, 1):
            # la fenêtre de partage de qos ne doit pas apparaître
            # self.bwshare.hide()
            self.close()
            dial_conf = create_error_dialog(_("Not enough zone to use QOS"))
            ret = dial_conf.run()
            dial_conf.destroy()
        else:
            # on montre la fenêtre de partage de qos
            self.bwshare.show_all()
            if library_store.options['qos'] == 0:
                self.unactived_qosoption_warning_label.show()
            else:
                self.unactived_qosoption_warning_label.hide()

    def gen_bandwidths(self, zones):
        """ génération de la section de modifications de bande passante 
            zones: liste d'objet de zone du modèles
        """
        self.zones = zones
        qosclasses = dict([(qos.zone, qos) for qos in library_store.qos])
        self.qosclasses = qosclasses
        total = len(zones)
        self.default_width = WIDTH/total
        # on crée des clés pour les zones qui n'ont pas de qos
        #FIXME: recuperation de l'id et libelle
        non_exist_qosslasses = dict([(zone.name, QosClass(id='IDINCONNU', 
                                                          bandwidth=self.default_width, 
                                                          libelle='qos de %s'%zone.name, 
                                                           priority='1', 
                                                           zone=zone.name))for zone in self.zones if zone.name not in qosclasses.keys()])

        self.qosclasses.update(non_exist_qosslasses)

        if len(zones) == 0:
            pass
        else:
#             # on détruit les anciennes zboxes (si la fenetre est rechargee)
#             while self.zboxes != []:
#                 self.zboxes[0].destroy()
#                 del self.zboxes[0]
            # calcul de la largeur d'une boite
            # création des zboxes pour chaque zone, sauf la zone en cours d'edition
            for zone in zones:

                if zone.name in qosclasses:
                    qosclass = qosclasses[zone.name]

                # si on est arrive a la fin
                if zones.index(zone)+1  == total:
                    self.add_box(zone.name, end=True)
                else:
                    self.add_box(zone.name)
        
    def color_range(self):
        "une couleur differente pour chaque zone"
        rangelist = [r[2] for r in self.draws]
        while 1:
            r = random.randrange(len(COLORS)-1)
            if r not in rangelist:
                break
        return r
        
    def area_expose(self, area, event):
        """callback permettant de lier la surface de dessin au widget
        name : nom de la zone"""
        
        for draw, layout, color_indice, name, libelle in self.draws:
            red = gtk.gdk.color_parse(COLORS[color_indice])
            gc = gtk.gdk.GC(draw.window)
            gc.set_rgb_fg_color(red)
            black = gtk.gdk.color_parse('#000000')
            gc_black = gtk.gdk.GC(self.bwshare.window)
            gc_black.set_rgb_fg_color(black)
            # recuperons la largeur du dessin
            width = draw.window.get_size()[0]
            # largeur finale
#            self.shares[name] = "%.2f" % float(average(width))
            #si la classe de qos existe on modifie son bandwidth sinon...
            self.qosclasses[name].set_bandwidth(average(width))
            draw.window.draw_rectangle(gc, True, 0, 0, width, HEIGHT)
            draw.window.draw_layout(gc_black,15, 11, layout)
            libelle.set_label("zone %s : %i" % (name, int(self.qosclasses[name].bandwidth)))

        
    def add_box(self, name, end=False):
        """ajout d'une zbox        """
        # box = gtk.HBox(False,0)
        # hbox = gtk.HBox(homogeneous=False, spacing=0)
        if not self.zboxes:
            paned = gtk.HPaned()
            self.zboxes.append(paned)
            self.container_widget.add(paned)
        else:
            paned = self.zboxes[-1]

        draw = gtk.DrawingArea()

        layout = pango.Layout(self.bwshare.get_pango_context())
        # l'exterieur correspond en fait au bastion lui-meme
        if name == "exterieur":
            layout.set_text("zone : bastion")
        else:
            layout.set_text("zone : %s " % name)

        color_indice = self.color_range()

        # label d'affichage de la repartition en pourcentage
        libelle = gtk.Label("zone %s : " % name)
        self.libelle_widget.pack_start(libelle)
        self.draws.append((draw, layout, color_indice, name, libelle))
         
        draw.set_size_request(int(self.qosclasses[name].bandwidth), HEIGHT)
                
        # paned.pack1(label, resize=False, shrink=False)
        paned.pack1(draw, resize=True, shrink=True)
        self.current_libelle = " zone: %s" % name
        
        draw.connect("expose-event", self.area_expose)

        newpaned = gtk.HPaned()
        if not end:
            paned.pack2(newpaned, resize=True, shrink=True)
        else:
            # la derniere case est vide, ça ne gene pas
            pass
        self.zboxes.append(newpaned)

    def close(self, *args):
        "fermeture de la fenetre"
        # self.bwshare.hide()
        self.bwshare.destroy()
        
    def response(self, button, response, *args):
        "callback d'appui sur ok-cancel"
        # enregistrons les valeurs de qos
        library_store.qos = self.qosclasses.values()
        library_store.set_bandwidth(self.upload_entry.get_text(), self.download_entry.get_text())
        self.close()

