# -*- coding: UTF-8 -*-
###########################################################################
# 
# Eole NG  
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  http://www.cecill.info/licences/Licence_CeCILL_V2-fr.html
# eole@ac-dijon.fr 
#  
###########################################################################

"""
Module concernant les groupes et utilisateurs (NuFW)
"""

import gtk, gtk.glade
import gobject
from era.noyau.pool import library_store
from era.noyau.fwobjects import UserGroup
from era.noyau.path import GID_TOUS, GID_GUEST
from era.ihm.ihm_utils import create_error_dialog, create_yes_no_dialog

class UserGroupDialog:
    """Gère les utilisateurs
    """


    def __init__(self, glade_file):
        """
        glade : l'objet XML glade
        """
        self.glade_file = glade_file
        self.glade = gtk.glade.XML(self.glade_file, 
                "user_group_dialog", "editeur")
        self.dlg = self.glade.get_widget("user_group_dialog")

        self.tree_view = self.glade.get_widget('user_group_treeview')
        self.user_group_label = self.glade.get_widget('user_group_label')
        self.edition_vbox  = self.glade.get_widget('edition_vbox')
        self.button_del_user_group = self.glade.get_widget('button_del_user_group1')
        self.add_user_group = self.glade.get_widget('add_user_group')
        self.edit_user_group = self.glade.get_widget('edit_user_group')
        self.user_group_name = self.glade.get_widget('user_group_name')
        self.user_group_id = self.glade.get_widget('user_group_id')

        handlers = {'on_user_group_dialog_response' : self.close,
                    'on_user_group_treeview_button_press_event':self.get_selected_clicked,
                    'on_add_user_group_button_clicked':self.add_user_group_clicked,
                    'on_button_del_user_group_clicked':self.del_user_group,
                    'on_button_valid_user_group_clicked':self.validate_edit,
                    'on_edit_group_button_clicked':self.edit_user_group_active,
                    'on_button_cancel_user_group_clicked':self.cancel_user_group,
                   }
        self.glade.signal_autoconnect(handlers)

        store = gtk.ListStore(gobject.TYPE_PYOBJECT, gobject.TYPE_STRING)

        renderer = gtk.CellRendererText()

        column = gtk.TreeViewColumn(_('user_group description'),
                renderer, text=1)
        column.set_expand(True)
        self.tree_view.set_model(store)
        self.tree_view.append_column(column)
        tree_sel = self.tree_view.get_selection()
        tree_sel.connect('changed', self.selected_user_group_changed)

        self.old_id = None
        self.selected_user_group = None

        for user_group in library_store.user_groups.values():
            store.append([user_group, user_group.name])

    def close(self, *args):
        self.dlg.hide()

    def cancel_user_group(self, *args):
        self.hide_show(False)

    def save_tags(self, model, path, current_iter, data):
        user_group = model.get_value(current_iter, 0)
        library_store.user_groups[user_group.id] = user_group

    def hide_show(self, state):
        if state:
            self.edition_vbox.show()
            self.user_group_label.hide()
            self.tree_view.set_sensitive(False)
            self.button_del_user_group.set_sensitive(False)
            self.add_user_group.set_sensitive(False)
            self.edit_user_group.set_sensitive(False)
        else:
            store, iter_sel = self.tree_view.get_selection().get_selected()
            self.edition_vbox.hide()
            self.user_group_label.show()
            self.tree_view.set_sensitive(True)
            self.add_user_group.set_sensitive(True)
            if iter_sel:
                self.button_del_user_group.set_sensitive(True)
                self.edit_user_group.set_sensitive(True)
            else:
                self.button_del_user_group.set_sensitive(False)
                self.edit_user_group.set_sensitive(False)

    def edit_user_group_active(self, *args):
        # récupération de l'objet sélectionnée
        store, iter_sel = self.tree_view.get_selection().get_selected()
        if iter_sel is not None:
            selected_user_group = store.get_value(iter_sel, 0)
            if selected_user_group is not None:
                self.old_id = selected_user_group.id
                self.hide_show(True)
                self.selected_user_group = selected_user_group
                # texte de description du groupe
                self.user_group_name.set_text(selected_user_group.name)
                self.user_group_name.set_sensitive(False)
                self.user_group_id.set_text(selected_user_group.id)


    def selected_user_group_changed(self, *args):
        # récupération de l'objet sélectionnée
        store, iter_sel = self.tree_view.get_selection().get_selected()
        if iter_sel is not None:
            selected_user_group = store.get_value(iter_sel, 0)
            if selected_user_group is not None:
                display = "name: %s\nid: %s" % (selected_user_group.name,
                        selected_user_group.id)
                self.user_group_label.set_text(display)
                self.button_del_user_group.set_sensitive(True)
                self.edit_user_group.set_sensitive(True)
                self.selected_user_group = selected_user_group

    def get_selected_clicked(self, widget, event, *args):
        """récupère le double click dans le treeview
        """
        # édition si double click
        if event.type == gtk.gdk._2BUTTON_PRESS:
            self.edit_user_group_active()
        
#    def get_selected(self,widget,*args):
#        """édite l'objet sélectionné
#        """
#        print "pouet"
#        store, iter_sel = self.tree_view.get_selection().get_selected()
#
#        if self.selected_user_group is not None:
#            # édition de la plage
#            dial_edit = UserGroupEditDialog(self.glade_file, 
#            self.tree_view.get_model(),iter_sel,self.selected_user_group)
#            dial_edit.show_dialog()

    def add_user_group_clicked(self, *args):
        """édite l'objet sélectionné
        """
        self.hide_show(True)
        self.user_group_id.set_text('')
        self.user_group_name.set_text('')
        self.user_group_name.set_sensitive(True)
        self.user_group_name.grab_focus()
        self.old_id = None

    def del_user_group(self, *args):
        """supprime l'objet sélectionné
        """
        selection = self.tree_view.get_selection()
        store, iter_sel  = selection.get_selected()

        if iter_sel is not None:
            user_group = store.get_value(iter_sel, 0)
            if self.selected_user_group.used > 0:
                # plage utilisée par des directives 
                dial_error = create_error_dialog(_("object still used"), self.dlg)
                dial_error.show()
            elif self.selected_user_group.id in (str(GID_TOUS), str(GID_GUEST)):
                # groupes réservés
                dlg = create_error_dialog(_("forbidden to modify this group"))
                dlg.run()
            else:
                dial_conf = create_yes_no_dialog(_("remove group confirmation : ") + self.selected_user_group.name)
                dial_conf.set_default_response(gtk.RESPONSE_NO)
                ret = dial_conf.run()
                dial_conf.destroy()
                if ret == gtk.RESPONSE_YES:
                    # suppression
                    store.remove(iter_sel)
                    del(library_store.user_groups[self.selected_user_group.id])
                    self.button_del_user_group.set_sensitive(False)
                    self.edit_user_group.set_sensitive(False)
                    self.user_group_name.set_text('')
                    self.user_group_id.set_text('')
                    self.user_group_label.set_text('')

    def existing_group_name_warning(self, name):
        """
        affiche un avertissement en cas de doublons
        """
        if str(name) in [ str(gr.name) for gr in library_store.user_groups.values()]:
            msg = _('identifier already exists')  + ' : %s' % name
            dial_alerte = create_error_dialog(msg)
            dial_alerte.show()
            return True
        else:
            return False

    def existing_group_gid_warning(self, gid):
        """
        affiche un avertissement en cas de doublons
        """
        if str(gid) in [ str(key) for key in library_store.user_groups.keys()]:
            msg = _('identifier already exists')  + ' : %s' % gid
            dial_alerte = create_error_dialog(msg)
            dial_alerte.show()
            return True
        else:
            return False

    def validate_edit(self, *args):
        """valide les modifications sur un groupe
        """
        selection = self.tree_view.get_selection()
        model, iter_sel  = selection.get_selected()
        name = self.user_group_name.get_text()
        gid = self.user_group_id.get_text()

        if self.old_id:
            # édition d'un groupe existant
            if self.old_id in (str(GID_TOUS), str(GID_GUEST)):
                # groupes réservés
                dlg = create_error_dialog(_("forbidden to modify this group"))
                dlg.run()
                return False
            elif self.old_id != gid:
                if self.existing_group_gid_warning(gid):
                    self.user_group_id.set_text(self.old_id)
                    self.user_group_id.grab_focus()
                    return False
                else:
                    del(library_store.user_groups[self.old_id])
        else:
            # ajout d'un nouveau groupe
            if self.existing_group_name_warning(name) or self.existing_group_gid_warning(gid):
                return
            model = self.tree_view.get_model()
            iter_sel  = model.append()
            new_user_group = UserGroup("-1", _('New'))
            self.selected_user_group = new_user_group
            library_store.user_groups[self.selected_user_group.id] = self.selected_user_group
            model.set_value(iter_sel, 0, new_user_group)
            model.set_value(iter_sel, 1, new_user_group.name)
            #self.glade.get_widget('user_group_name').set_text(new_user_group.name)
            #self.glade.get_widget('user_group_id').set_text(new_user_group.id)
            # on sélectionne le nouveau groupe
            sel = self.tree_view.get_selection()
            sel.select_iter(iter_sel)
 
        self.selected_user_group.name = name
        self.selected_user_group.id = gid
        library_store.user_groups[gid] = self.selected_user_group
        model.set_value(iter_sel, 0, self.selected_user_group)
        model.set_value(iter_sel, 1, self.selected_user_group.name)
        self.hide_show(False)
        self.old_id = None
        self.selected_user_group_changed()
 
    def show_dialog(self):
        self.dlg.show_all()

        self.user_group_label.show()
        self.hide_show(False)

