# -*- coding: utf-8 -*-
"""
génération du fichier de qos
"""
import autopath
from os import system, unlink
from os.path import join, isfile
from era.noyau.qos_externe import *

TEMPFILE = "./tmpfile_test_qos.txt"
TEMPFILE2 = "./tmpfile_test_qos2.txt"

def setup_module(module):
    # lancement de la qos generee
    model_file = join(autopath.HERE, "data", "test_qos.xml")
    qos_data = get_qos_classes(model_file)
    export_to_qos_file(TEMPFILE, qos_data)

    # lancement de la qos generee
    model_file2 = join(autopath.HERE, "data", "test_qos2.xml")
    qos_data = get_qos_classes(model_file)
    export_to_qos_file(TEMPFILE, qos_data)


def test_generated_file():
    """

    le fichier générér doit ressembler à quelque chose comme ça :

    # VARIABLES DE CONFIGURATION

    NB_Inter=4

    # DEBITS Internet en kbits (mettre un peu en dessous des debits reels)

    DOWN=100
    UP=1000

    # TAUX minimum  (en pourcentage)
    # Attention: le cumul des taux < = 100 pourcent ! #

    #Par defaut la carte eth0 est la sortie sur Internet.
    #Le taux donne a cette carte correspond aux services installes sur Amon, c'est a dire essentiellement le proxy Web.
    TX_INT_1=16
    TX_INT_3=26
    TX_INT_2=35
    TX_INT_0=11

    """
    result = open(TEMPFILE).read()
    assert "NB_Inter=4" in result
    assert "DOWN=100" in result
    assert "UP=1000" in result
    assert "TX_INT_1=16" in result

def test_qos_unactivated():
    assert isfile(TEMPFILE2) == False

def teardown_module(module):
    unlink(TEMPFILE)
