# -*- coding: utf-8 -*-
###########################################################################
#
# Eole NG
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  http://www.cecill.info/licences/Licence_CeCILL_V2-fr.html
# eole@ac-dijon.fr
#
###########################################################################

"""Utilitaire simplissime de templating
pour generer une instruction %for de cheetah
"""
class Template:
    """genere un template cheetah (syntaxe for)
    en notation creole pointee pour les variables maitre et esclaves
    """
    def __init__(self, masters, template):
        """
        :master: variable maitre au sens creole
        :slaves: liste des variables esclaves
                 a noter que les valeurs multivaluees autres ne peuvent etre
                 que des esclaves (les autres valeurs multiples sont en notation
                 avec des crochets)
        :template: ligne a traiter
        """
        self.template = template
        self.masters = masters

    def __str__(self):
        line = str(self.template % self)
        line = self.gen_for(line)
        return line

    def __getitem__(self, key):
        if key in self.masters.keys():
            return "%%%%_v_%s" % key
        else:
            master = None
            for _master, slaves in self.masters.items():
                if key in slaves:
                    master = _master
                    break
            if not master:
                raise Exception("La variable %s n'a pas de maitre" % key)
            return "%%%%_v_%s.%s" % (master, key)

    def gen_for(self, line):
        """la ligne passee en parametre est le corps du template
        il reste a la transformer en boucle for au sens cheetah"""
        for master in self.masters.keys():
            line = """%%for %%%%_v_%s in %%%%%s
%s
%%end for""" % (master, master, line)
        return line

#def test():
#    "test avec master et slave"
#    print Template(master="name", slaves=["tintin"],
#                   template="Hello %(name)s and %(tintin)s!")
#    """
#    %for v in
#    Hello %%v and %%v.tintin!
#    %end for
#    """
#    "test sans slave"
#    print Template(master="name", slaves=[],
#                   template="Hello %(name)s!")
#
