# -*- coding: UTF-8 -*-
###########################################################################
# 
# Eole NG  
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  http://www.cecill.info/licences/Licence_CeCILL_V2-fr.html
# eole@ac-dijon.fr 
#  
###########################################################################

"""Module de stockage et de manipulation structurée de données issue d'un fichier de type csv
"""

import os.path , csv

class CSVStorage:
    """Stockage des données issues de l'ead dans un fichier csv
    """
    
    def __init__(self, file="ead.csv", prepath=None):
        """
        @param file: nom court ou bien nom long du fichier de stockage
        @param prepath: chemin du fichier de sauvegarde
        """
        # si le prepath n'est pas utilisé
        self.file = file
        if prepath:
            self.prepath = prepath
        else: self.prepath = ""
        # 
        self.storage_file = os.path.join(self.prepath, self.file)
        self._load_data()

    def _load_data(self):
        """Chargement des données à partir du fichier csv
        Le fichier csv est dans le format category,url,id,name,page_url
        """
        self.data = []
        # à priori c'est une liste de rows
        csv_reader = csv.reader(file(self.storage_file, 'r'))
        
        keywords = ['tag','attrs','occurence', 'carte']

        for row in csv_reader:
            kwargs = dict(zip(keywords, row))
            self.data.append(kwargs)

    def write_data(self):
        """Ecriture dans le fichier de stockage
        """
        fd = file(self.storage_file, 'w')
        writer = csv.writer(fd)
        writer.writerows(self.data)

    def get_data(self):
        """Récupère les données à enregistrer
        """
        return self.data
    
    def set_data(self, data):
        """Renseigne les données à enregistrer
        @param data: [ ['tag','attrs','occurence'] ]
        """
        self.data = data

def _test():
    """
    optional = matrix_model.get_active_list()
    c = CSVStorage(options.gen_external_file)
    c.set_data(optional)
    c.write_data()
    """

if __name__ == "__main__":
    c = CSVStorage("test.txt")
    print c.get_data()


