# -*- coding: UTF-8 -*-
"""Module de tests unitaires pour l'écriture des règles iptables
"""
import sys

import autopath
from era.backend.iptwriter import IPTWriter
from era.backend.utils import LStringIO

def setup_module(module):
    """Initialisation du writer
    """
    module.output = LStringIO()
    module.writer = IPTWriter(output = module.output)

def test_new_chain():
    """    L{era.backend.iptwriter.IPTWriter.new_chain}

    ajout d'une nouvelle chaine
    """
    writer.new_chain('chaineA')
    assert output.getvalue() == '/sbin/iptables -t filter -N chaineA\n'
    
    writer.new_chain('chaineB', 'mangle')
    assert output[-1] == '/sbin/iptables -t mangle -N chaineB\n'

def test_delete_chain():
    """L{era.backend.iptwriter.IPTWriter.delete_chain}
    suppression d'une chaine
    """
    writer.delete_chain('chaineA')
    assert '/sbin/iptables -t filter -X chaineA\n' in output.getvalue()
    writer.delete_chain('chaineB', 'mangle')
    assert output[-1] == '/sbin/iptables -t mangle -X chaineB\n'

def test_flush_chain():
    """L{era.backend.iptwriter.IPTWriter.flush_chain}    
    Teste la méthode de flush d'une chaine
    
    """
    writer.flush_chain('chaineA')
    assert '/sbin/iptables -t filter -F chaineA\n' in output.getvalue()
    writer.flush_chain('chaineB', 'mangle')
    assert output[-1] == '/sbin/iptables -t mangle -F chaineB\n'

def test_basic_append():
    """L{era.backend.iptwriter.IPTWriter.append_rule_from_params}
    ajout de règle *basiquement*
    Ce test n'a pour but que de tester le comportement
    de la méthode append_rule, et ne représente pas
    un cas utilisable de règle iptable
    """
    writer.append_rule_from_params('chaineA', 'filter', [], None)
    assert '/sbin/iptables -t filter -A chaineA \n' in output.getvalue()

