# -*- coding: utf-8 -*-
###########################################################################
#
# Eole NG
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  http://www.cecill.info/licences/Licence_CeCILL_V2-fr.html
# eole@ac-dijon.fr
#
###########################################################################

"""generation de code cheetah sur des valeurs creole multivaluees"""

import re, sys
from creole.loader import creole_loader
from era.backend.template import Template

loader = creole_loader()


class Multivar:
    """generation de code cheetah sur des valeurs multivaluees"""
    def __init__(self, lines=[]):
        """:lines: lignes iptables generees par le compilateur"""
        self.lines = lines

    def _getcreolevar_inline(self, line):
        """:return: la liste des variables creole dans une ligne
        """
        # regexp de motif %%mavariable[] ou mavariable[1]
        monovarregexp = re.compile('%%(\w*)\[[0-9]*\]')
        # regexp de motif %%mavariable
        multivarregexp = re.compile('%%(\w*)')

        # toute les variables templates sont parsees
        multivars = re.findall(multivarregexp, line)
        for var in multivars:
            # cette variable ne doit pas etre suivie de crochets
            if var not in re.findall(monovarregexp, line):
                yield var

    def process(self):
        """collecte les valeurs multivaluees dans le dictionaire creole
        """
        for line in self.lines:
            masters = {}
            tpline = line
            #utilisation d'un set pour n'obtenir qu'une occurence de chaque variable
            inline_vars = set(self._getcreolevar_inline(tpline))
            for var in inline_vars:
                try:
                    path = loader.creole.find_first(byname=var, type_='path')
                except AttributeError:
                    raise Exception("\n variable inconnue : " + var + " dans la regle : " + line + "\n")
                spath = path.split('.')
                opt = loader.unwrap_from_path(path)
                #it's a slave option
                if len(spath) == 4 and spath[2] != spath[3]:
                    master = spath[2]
                    #plusieurs esclaves de la même master ou master déjà rencontrée
                    masters.setdefault(master, []).append(var)
                    tpline = tpline.replace("%%" + var, "%("+ var + ")s")
                elif opt.impl_is_multi():
                    #si c'est une master ou une multi isolée
                    #ou une "container_var"
                    #considère que c'est une master
                    masters.setdefault(var, [])
                    tpline = tpline.replace("%%" + var, "%("+ var + ")s")
                else:
                    # doubles % pour les variables non multi-valuees
                    tpline = tpline.replace("%%" + var, "%%%%" + var)

            if masters != {}:
                # generation du template cheetah
                tpl = Template(masters=masters, template=tpline)
                # pour qu'il n'y ait qu'une seule ligne a chaque fois -> split
                newline = str(tpl).split('\n')
                for n in newline:
                    yield n + '\n'
            else:
                yield line
