# -*- coding: UTF-8 -*-
###########################################################################
#
# Eole NG
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  http://www.cecill.info/licences/Licence_CeCILL_V2-fr.html
# eole@ac-dijon.fr
#
###########################################################################
#from era.noyau.dpatterns import Singleton
"gestion des exceptions pour une directive (avec ipsets)"
import gtk, gtk.glade
import gobject
from era.ihm.ihm_utils import create_error_dialog, create_yes_no_dialog

class DirectiveIpsets:
    def __init__(self, glade_file):
        self.glade_file = glade_file
        # new or add flag
        self.addflag = False
        self.glade = gtk.glade.XML(self.glade_file, "ipsets_dialog", "editeur")
        self.dlg = self.glade.get_widget("ipsets_dialog")
        self.tree_view = self.glade.get_widget('ipsets_treeview')
        self.button_del_ipsets = self.glade.get_widget('button_del_ipsets')
        self.add_ipsets = self.glade.get_widget('add_ipsets')
        self.edit_ipsets = self.glade.get_widget('edit_ipsets')
        #
        self.ipsets_ip_entry = self.glade.get_widget('ipsets_ip_entry')
        self.ipsets_name_entry = self.glade.get_widget('ipsets_name_entry')
        self.ipsets_eolvar_entry = self.glade.get_widget('ipsets_eolvar_entry')
        self.src_ipsets_radiobutton = self.glade.get_widget('src_ipsets_radiobutton')
        self.dest_ipsets_radiobutton = self.glade.get_widget('dest_ipsets_radiobutton')
        self.ipsets_name_radiobutton  = self.glade.get_widget('ipsets_name_radiobutton')
        self.ipsets_eolvar_radiobutton = self.glade.get_widget('ipsets_eolvar_radiobutton')
        self.ipsets_ip_radiobutton = self.glade.get_widget('ipsets_ip_radiobutton')
        #
        self.edition_vbox = self.glade.get_widget('edition_vbox')
        self.ipsets_label = self.glade.get_widget('ipsets_label')

        handlers = {'on_ipsets_dialog_response' : self.close_dialog,
                    'on_ipsets_treeview_button_press_event':self.callback_treeview_double_click,
                    'on_add_ipsets_button_clicked':self.callback_add,
                    'on_button_del_ipsets_clicked':self.callback_del,
                    'on_button_valid_ipsets_clicked':self.callback_validate,
                    'on_edit_ipsets_button_clicked':self.callback_edit,
                    'on_button_cancel_ipsets_clicked':self.callback_cancel,
                   }
        self.glade.signal_autoconnect(handlers)
        self._init_treeview()
        # we don't use the exception dialog at init time because
        # self.exceptions has not been set yet, so let's hide the widget
        self.exceptions = []
        self.close_dialog()

    def _init_treeview(self):
        self.store = gtk.ListStore(gobject.TYPE_PYOBJECT, gobject.TYPE_STRING,
          gobject.TYPE_BOOLEAN, gobject.TYPE_BOOLEAN)
        self.store.clear()
        col_names = [_("name"), _("source"), _("destination")]
        col_index = 1
        for col_name in col_names:
            if col_index == 1:
                renderer = gtk.CellRendererText()
                column = gtk.TreeViewColumn(col_name, renderer, text = col_index)
            else:
                renderer = gtk.CellRendererToggle()
                column = gtk.TreeViewColumn(col_name, renderer, active = col_index)
            self.tree_view.append_column(column)
            col_index += 1

        self.tree_view.set_model(self.store)
        self.tree_view.set_headers_visible(True)

        tree_sel = self.tree_view.get_selection()
        tree_sel.connect('changed', self.callback_treeview_get_selected)
        self.selected_ipsets = None

    def _flush_treeview(self):
        self.store.clear()

    def _fill_treeview(self):
        self._flush_treeview()
        for exc in self._exc_as_list(self.exceptions):
            # [exc, 'ip', 'src', 'dest']
            self.store.append(exc)

    def _exc_as_list(self, exceptions):
        for exc in exceptions:
            exc_list = [exc]
            exc = self._filter_exception(exc)
            exc_list.append(exc['ipname'])
            exc_list.extend([exc['src'], exc['dest']])
            yield exc_list

    def close_dialog(self, *args):
        "close widget"
        self.dlg.hide()
        self.push_exceptions()

    def push_exceptions(self):
        self.exceptions

    def _hide_show(self, state):
        if state:
            self.edition_vbox.show()
            self.ipsets_label.hide()
            self.tree_view.set_sensitive(False)
            self.button_del_ipsets.set_sensitive(False)
            self.add_ipsets.set_sensitive(False)
            self.edit_ipsets.set_sensitive(False)
        else:
            store, iter_sel = self.tree_view.get_selection().get_selected()
            self.edition_vbox.hide()
            self.ipsets_label.show()
            self.tree_view.set_sensitive(True)
            self.add_ipsets.set_sensitive(True)
            if iter_sel:
                self.button_del_ipsets.set_sensitive(True)
                self.edit_ipsets.set_sensitive(True)
            else:
                self.button_del_ipsets.set_sensitive(False)
                self.edit_ipsets.set_sensitive(False)

    def callback_edit(self, *args):
        "edit button"
        store, iter_sel = self.tree_view.get_selection().get_selected()
        if iter_sel is not None:
            selected_ipsets = store.get_value(iter_sel, 0)
            if selected_ipsets is not None:
                self._hide_show(True)
                self.selected_ipsets = selected_ipsets
                self.ipsets_name_entry.set_text(selected_ipsets['name'])
                self.ipsets_name_entry.set_sensitive(True)
                self.ipsets_ip_entry.set_text(selected_ipsets['ip'])
                self.ipsets_ip_entry.set_sensitive(True)
                self.ipsets_eolvar_entry.set_text(selected_ipsets['eolvar'])
                self.ipsets_eolvar_entry.set_sensitive(True)
                self.src_ipsets_radiobutton.set_active(selected_ipsets['src'])
                self.dest_ipsets_radiobutton.set_active(selected_ipsets['dest'])
                getattr(self, 'ipsets_' + selected_ipsets['is_active'] + '_radiobutton').set_active(True)

    def _display_exception(self, exc):
        return "ip or name: %(ipname)s \nsrc:%(src)s \ndest:%(dest)s"% exc

    def _filter_exception(self, exc):
        ipname = None
        if  str(exc['ip']).strip() != '':
            ipname = exc['ip']
            exc['is_active'] = 'ip'
        elif  str(exc['name']).strip() != '':
            ipname = exc['name']
            exc['is_active'] = 'name'
        elif str(exc['eolvar']).strip() != '':
            lvar = exc['eolvar']
            lvar = str(lvar).strip()
            if not lvar.startswith("%%"):
                exc['eolvar'] = "%%"+ lvar
            ipname = exc['eolvar']
            exc['is_active'] = 'eolvar'
        else:
            raise Exception("ipset extremity has no valid name or ip")
        exc['ipname'] = ipname
        return exc

    def callback_treeview_get_selected(self, *args):
        "click in treeview"
        store, iter_sel = self.tree_view.get_selection().get_selected()
        if iter_sel is not None:
            selected_ipsets = store.get_value(iter_sel, 0)
            if selected_ipsets is not None:
                selected_ipsets = self._filter_exception(selected_ipsets)
                self.ipsets_label.set_text(
                    self._display_exception(selected_ipsets))
                self.button_del_ipsets.set_sensitive(True)
                self.edit_ipsets.set_sensitive(True)
                self.selected_ipsets = selected_ipsets

    def callback_treeview_double_click(self, widget, event, *args):
        "double click in treeview"
        # édition si double click
        if event.type == gtk.gdk._2BUTTON_PRESS:
            self.callback_edit()

    def callback_add(self, *args):
        "add button"
        self._hide_show(True)
        self.flush_dialog()
        self.addflag = True

    def flush_dialog(self):
        "flushes the add/del/modify vbox"
        self.ipsets_ip_entry.set_text('')
        self.ipsets_ip_entry.set_sensitive(True)
        self.ipsets_ip_entry.grab_focus()
        self.ipsets_name_entry.set_text('')
        self.ipsets_ip_entry.set_sensitive(True)
        self.ipsets_ip_entry.set_text('')
        self.ipsets_ip_entry.set_sensitive(True)
        self.ipsets_eolvar_entry.set_text('')
        self.ipsets_eolvar_entry.set_sensitive(True)
        self.src_ipsets_radiobutton.set_active(True)
        self.dest_ipsets_radiobutton.set_active(False)
        self.ipsets_ip_radiobutton.set_active(True)

    def callback_del(self, *args):
        "del button"
        selection = self.tree_view.get_selection()
        store, iter_sel  = selection.get_selected()
        if iter_sel is not None:
            ipsets = store.get_value(iter_sel, 0)
            dial_conf = create_yes_no_dialog(_("remove ipsets exception confirmation : ") + self.selected_ipsets['name'])
            dial_conf.set_default_response(gtk.RESPONSE_NO)
            ret = dial_conf.run()
            dial_conf.destroy()
            if ret == gtk.RESPONSE_YES:
                # suppression
                self.store.remove(iter_sel)
                self.flush_dialog()
                self.button_del_ipsets.set_sensitive(False)
                self.edit_ipsets.set_sensitive(False)
        self.update_exception_list()
    def callback_cancel(self, *args):
        "cancel button"
        self._hide_show(False)

    def update_exception_list(self):
        treeiter = self.store.get_iter_first()
        exceptions = []
        if treeiter is not None:
            exceptions.append(self.store.get_value(treeiter, 0))
            while treeiter != None:
                treeiter = self.store.iter_next(treeiter)
                if treeiter != None:
                    exceptions.append(self.store.get_value(treeiter, 0))
        self.exceptions = exceptions

    def _validate_entry(self, wgtname):
        text = getattr(self, 'ipsets_' + wgtname + '_entry').get_text()
        radio = getattr(self, 'ipsets_' + wgtname + '_radiobutton').get_active()
        if radio == True and text.strip() == '':
            dial_conf = create_error_dialog(_("%s selected but no %s filled"%(wgtname, wgtname) ))
            dial_conf.set_default_response(gtk.RESPONSE_NO)
            ret = dial_conf.run()
            dial_conf.destroy()

    def callback_validate(self, *args):
        "validate button"
        for wgtname in ['name', 'ip', 'eolvar'] :
           self._validate_entry(wgtname)

        if self.addflag:
            self._add_ipsets()
        else:
            edited_ipsets = self._get_values()
            edited_ipsets = self._filter_exception(edited_ipsets)
            selection = self.tree_view.get_selection()
            model, iter_sel  = selection.get_selected()
            model.set_value(iter_sel, 0, edited_ipsets)
            model.set_value(iter_sel, 1, edited_ipsets['ipname'])
            model.set_value(iter_sel, 2, edited_ipsets['src'])
            model.set_value(iter_sel, 3, edited_ipsets['dest'])
            self._hide_show(False)
            # for the label to be updated
            self.callback_treeview_get_selected()
        self.addflag = False
        self.update_exception_list()
        self._hide_show(False)

    def _get_values(self):
        ip = self.ipsets_ip_entry.get_text()
        name = self.ipsets_name_entry.get_text()
        eolvar = self.ipsets_eolvar_entry.get_text()
        srcflag = self.src_ipsets_radiobutton.get_active()
        if srcflag:
            src = True
            dest = False
        else:
            src = False
            dest = True
        return dict(ip=ip, name=name, eolvar=eolvar, src=src, dest=dest)

    def _add_ipsets(self):
        model = self.tree_view.get_model()
        iter_sel  = model.append()
        new_ipsets = self._get_values()
        new_ipsets = self._filter_exception(new_ipsets)
        self.selected_ipsets = new_ipsets
        model.set_value(iter_sel, 0, new_ipsets)
        model.set_value(iter_sel, 1, new_ipsets['ipname'])
        model.set_value(iter_sel, 2, new_ipsets['src'])
        model.set_value(iter_sel, 3, new_ipsets['dest'])
        self.flush_dialog()

    def show_dialog(self):
        """show widget.

        must call set_exceptions() before
        """
        self.dlg.show_all()
        self._hide_show(False)
        #self.reload_exceptions_in_treeview()

    def reload_exceptions_in_treeview(self):
        self._flush_treeview()
        self._fill_treeview()

    def set_exceptions(self, exceptions):
        "if new exceptions is retrieved, put it in the treeview"
        if exceptions is None:
            exceptions = []
        self.exceptions = exceptions
        self.reload_exceptions_in_treeview()

    def get_exceptions(self):
        return self.exceptions

