# -*- coding: UTF-8 -*-
###########################################################################
# 
# Eole NG  
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  http://www.cecill.info/licences/Licence_CeCILL_V2-fr.html
# eole@ac-dijon.fr 
#  
###########################################################################

"""
Module contenant les erreurs liées à l'ajout de zones.
"""

__version__ = "$Id: erreurs.py,v 1.3 2004/05/21 12:58:45 bboiget Exp $"


# Définition des exceptions pour les listes d'objets
class ZoneError(Exception):
    pass

class ExistingZoneError(ZoneError):
    pass

class InvalidZoneError(ZoneError):
    pass

class TrigrammeError(ZoneError):
    pass

class EmptyNameError(Exception):
    pass

class ExistingNameError(Exception):
    pass

class InvalidPortListError(Exception):
    pass

class BadPortError(Exception):
    pass

class TagError(Exception):
    pass

class InvalidNetbiosField(Exception):
    """Exception levée quand le champ 'netbios' du fichier .ini est
    mal formée"""
    pass
    
    

