# -*- coding: utf-8 -*-
###########################################################################
#
# Eole NG
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  http://www.cecill.info/licences/Licence_CeCILL_V2-fr.html
# eole@ac-dijon.fr
#
###########################################################################

from era.noyau.dpatterns import Observable
from era.noyau.erreurs import EmptyNameError, ExistingZoneError, TrigrammeError
from era.noyau.path import DEFAULT_UPLOAD_BANDWIDTH, DEFAULT_DOWNLOAD_BANDWIDTH
from era import version
#from era.ihm.model import option

class LibraryStore: #(option.OptionModel):
    """
        callse de collecte des objets qui sont en dehors de la matrice de flux,
        pour
        - create
        - edit
        - remove
        - update

    """
#    __observables__ = ('options', 'rules', )
#    def __init__(self):
    """
    :services: fwobjects/Services
    :service_groups: fwobjects/ServiceGroup
    :extremite: fwobjects/Extremite
    :user_groups: fwobjects/UserGroup
    :rules: inclusions statiques
    :ranges: plages horaires
    :app_groups: fwobjects/ApplicationGroup
    :applications: fwobjects/Applications
    :qos: qualite de service
    """
    version = version
    services = []
    service_groups = []
    extremites = {}
    tags = {}
    ranges = {}
    rules = None
    ## debut informations specifiques à nufw
    user_groups = {}
    app_groups = {}
    applications = {}
    ## fin nufw
    # les options du modèle (spécifique au modèle xml et pas à l'application)
    # netbios : activation ou desactivation du netbios
    ##  groupe : mode normal ou mode utilisateurs pour la gestion de qos
    options = {'netbios':1, 'qos':'0'}
    # classes de qos
    qos = []
    # bandwidth en upload et download valeurs par defaut
    upload_bandwidth = DEFAULT_UPLOAD_BANDWIDTH
    download_bandwidth = DEFAULT_DOWNLOAD_BANDWIDTH
    # valeur par defaut du modele
    model = None

    def set_version(self, cur_version):
        """la version des modeles xml"""
        self.version = float(cur_version)

    def get_version(self):
        """la version des modeles xml"""
        return self.version

    def set_options(self, options):
        """options: dictionnaire des options"""
        self.options.update(options)

    def add_range(self, range):
        self.ranges.append(range)

    def add_service(self, service):
        # Vérifier que ce service est valide ..., sinon exception
        self.services.append(service)

    def add_qos(self, qos):
        """ajout d'une classe de qos"""
        self.qos.append(qos)

    def add_group(self, group):
        # Vérifier que ce groupe est valide ..., sinon exception
        self.service_groups.append(group)

    def add_application_group(self, app_group):
        """
            :appgroup: [fwobjects/AppGroup]
        """
        self.app_groups[app_group.name] = app_group

    def add_application_groups(self, app_groups):
        """
            :app_groups: app_groups[name] = fwobj/ApplicationGroup

        """
        self.app_groups.update(app_groups)

    def add_application(self, application):
        """
            :application: fwobj/Application
        """
        self.applications[application.name] = application

    def add_applications(self, applications):
        """
            applications = dict(name=Application)
        """
        self.applications.update(applications)

    def get_applications_paths(self, application_names):
        """ :application_names: liste des noms des applications
        """
        paths = []
        for app_name in application_names:
            paths.extend(self.applications[app_name].get_paths())
        return paths

    def get_app_group(self, app_group_name):
        """
            :return: fwobjects/AppGroup
        """
        if app_group_name in self.app_groups.keys():
            return self.app_groups[unicode(app_group_name)]
        return None

    def add_extremite(self, extr):
        # Vérifier que cette extremite est valide ..., sinon exception
        self.extremites[extr.name] = extr
        # self.extremites.append(extr)

    def clear(self):
        self.services = []
        self.service_groups = []
        self.rules = None
        self.tags = {}
        self.ranges = {}
        self.extremites = {}
        self.user_groups = {}
        self.options['netbios'] = 1
        self.options['qos'] = '0'
        # self.options['user'] = 0
        self.qos = []
        self.app_groups = {}
        self.applications = {}

    def set_bandwidth(self, upload, download):
        """permet de renseigner la bande passante extérieure
        en upload et en download"""
        self.upload_bandwidth = upload
        self.download_bandwidth = download

    def clear_tags(self):
        self.tags={}

    def remove_extremites(self, zone):
        """Retire l'ensemble des extrémités liées à une zone.
        """
        for e in self.get_zone_extremites(zone):
            del self.extremites[e.name]

    def get_zone_extremites(self, zone):
        """Renvoie la liste des extremites d'une zone
        """
        return [ext for ext in library_store.extremites.values() if ext.zone == zone]

    def get_zone_name_extremites(self, zname):
        """Renvoie la liste des extremites d'une zone
        """
        return [ext for ext in library_store.extremites.values() if ext.zone.name == zname]

    def save(self, stream, indent = 0):
        """Méthode qui sauvegarde, au format interne, les données
        du library_store
        """
        # escaping xml characters in static rules
        from xml.sax.saxutils import escape
        if self.rules is not None:
            rules = escape(self.rules)
            stream.write('%s<include>%s</include>\n'% (" "*indent, rules) )
        else:
            stream.write('%s<include></include>\n'% (" "*indent) )
        # services
        stream.write('%s<services>\n'% (" "*indent))
        for service in self.services:
            # pour pas sauver en double lors d'héritage
            if not service.is_inherited():
                service.save(stream, indent+4)
        for group in self.service_groups:
            if not group.is_inherited():
                group.save(stream, indent+4)
        stream.write('%s</services>\n'% (" "*indent))

        # classes de qos
        stream.write('%s<qosclasses upload="%s" download="%s">\n'% (" "*indent, self.upload_bandwidth, self.download_bandwidth))
        for qos in self.qos:
            qos.save(stream, indent+4)
        stream.write('%s</qosclasses>\n'% (" "*indent))
        # extremites
        stream.write('%s<extremites>\n'% (" "*indent))
        for extr in self.extremites.values():
            if not extr.is_inherited():
                extr.save(stream, indent+4)
        stream.write('%s</extremites>\n'% (" "*indent))
        stream.write('%s<ranges>\n'% (" "*indent))
        for timerange in self.ranges.values():
            if not timerange.is_inherited():
                timerange.save(stream, indent+4)
        stream.write('%s</ranges>\n'% (" "*indent))
        # fwobjects/UserGroup
        stream.write('%s<user_groups>\n'% (" "*indent))
        for user_group in self.user_groups.values():
            if not user_group.is_inherited():
                user_group.save(stream, indent+4)
        stream.write('%s</user_groups>\n'% (" "*indent))
        # fwobjects/AppGroup
        stream.write('%s<applications>\n'% (" "*indent))
        for app_group in self.app_groups.values():
            app_group.save(stream, indent+4)
        for application in self.applications.values():
            application.save(stream, indent+4)
        stream.write('%s</applications>\n'% (" "*indent))

# initialisation, (c'est un singleton)
library_store = LibraryStore()
