#!/bin/bash
. /usr/lib/eole/ihm.sh
MDIR="/usr/share/era/modeles"
EOLE_DIR="/var/lib/eole"
REGLES_CSV="/var/lib/eole/config/regles.csv"
IPSET_TMP_DIR="/var/lib/eole/ipsets"

type_amon=$(CreoleGet type_amon)
mode_conteneur_actif=$(CreoleGet mode_conteneur_actif)

## existance du fichier xml firewall
if [ ! -e $MDIR/${type_amon}.xml ]
then
    EchoRouge "!! Modèle ${type_amon}.xml non trouvé !!"
    exit 1
fi

# script de lancement du compilateur de regle (backend) era
export PYTHONPATH="/usr/share/:/usr/share/eole/:$PYTHONPATH"
cd /usr/share/era/

### verifions en tout premier lieu que le firewall est bien prevu pour l'authentification
#if [ "$activer_nufw" != "oui"  ]
#then
#    if [ "`./backend/is_authenticated $MDIR/${type_amon}.xml`" = "True"  ]
#    then
#        EchoRouge "!! ATTENTION: le modele Era est authentifiant alors que le pare-feu n'est pas defini comme etant authentifiant !!"
#        exit 1
#    fi
#fi


#support des regles eole-firewall
#/usr/share/eole/bastion/bin/bastion
#if [ $? -eq 1 ]; then
#    EchoRouge "!! Erreur a la generation des regles eole-firewall !!"
#    exit 1
#fi

mkdir -p $IPSET_TMP_DIR
rm -f $IPSET_TMP_DIR/*
rm -rf /tmp/containers
if [ "$mode_conteneur_actif" = "oui" ]; then
    mkdir -p /tmp/containers/iptables
    mkdir -p /tmp/containers/tcpwrapper
fi
./backend/compiler -o ${EOLE_DIR}/firewall.tmpl -a /usr/share/era/backend/data/active_tags -d ${REGLES_CSV} -t ${EOLE_DIR}/regles.tmpl -s $IPSET_TMP_DIR $MDIR/${type_amon}.xml
if [ ! $? = 0 ]; then
    exit 1
fi

# gestion du tcpwrapper
/usr/share/era/backend/hostallow.py $MDIR/${type_amon}.xml  /usr/share/era/backend/data/active_tags

if [ "$mode_conteneur_actif" = "oui" ]; then
    rm -f /opt/lxc/*/iptables
    rm -f /opt/lxc/*/tcpwrapper
    for container in $(ls /tmp/containers/iptables/); do
        container_name=${container%%.*}
        container_path=$(CreoleGet container_path_$container_name)
        [ ! -f $container_path/../iptables ] && echo "#!/bin/bash" > $container_path/../iptables
        cat /tmp/containers/iptables/$container >> $container_path/../iptables
    done
    for container in $(ls /tmp/containers/tcpwrapper/); do
        container_name=${container%%.*}
        container_path=$(CreoleGet container_path_$container_name)
        cat /tmp/containers/tcpwrapper/$container >> $container_path/../tcpwrapper
    done
    for container in $(CreoleGet --groups); do
        if [ ! $container = 'root' ]; then
            container_path=$(CreoleGet container_path_$container)
            if [ -f $container_path/../iptables ]; then
                CreoleCat -s $container_path/../iptables -o $container_path/usr/share/eole/bastion/data/50-era
                chmod +x $container_path/usr/share/eole/bastion/data/50-era
            fi
            if [ -f $container_path/../tcpwrapper ]; then
                CreoleCat -s $container_path/../tcpwrapper -o $container_path/etc/eole/hosts.allow
            fi
        fi
    done
    rm -rf /tmp/containers
fi

if [ $? -eq 1 ]; then
    EchoRouge "!! Erreur lors de la generation des regles iptables par era !!"
    exit 1
fi

# compilation du fichier de règles optionnelles si nécessaire
grep -q "%" ${EOLE_DIR}/regles.tmpl
if [ $? -eq 0 ];then
    CreoleCat -s ${EOLE_DIR}/regles.tmpl -o ${REGLES_CSV}
else
    /bin/cp -f ${EOLE_DIR}/regles.tmpl ${REGLES_CSV}
fi
## authentification nufw
# instanciation "manuelle" du script de firewall
CreoleCat -s ${EOLE_DIR}/firewall.tmpl -o /sbin/lance.firewall
if [ $? -eq 0 ];then
    # attribution des droits au fichier lance.firewall
    chmod 700 /sbin/lance.firewall
else
    # le script lance.firewall ne doit pas etre exectute.
    exit 1
fi
## horaires de nuit du pare-feu
#/usr/share/era/backend/horaires_firewall -i /var/lib/eole/config/horaires.txt >> /sbin/lance.firewall
if [ -e /var/lib/eole/config/horaires.txt ]; then
    echo
    EchoOrange "Les horaires de pare-feu ne sont plus pris en compte : le fichier /var/lib/eole/config/horaires.txt est ignoré"
fi

# Instanciation manuelle du modele Era :

# gestion de la qos
tmp_xml=$(mktemp)
rm -f /etc/qoseole.conf
./backend/qos_era_externe $MDIR/${type_amon}.xml -o $tmp_xml
if [ -s $tmp_xml ]; then
    CreoleCat -s $tmp_xml -o /etc/qoseole.conf
fi
rm $tmp_xml

# ipsets rules that comes from exceptions
mkdir -p /usr/share/era/ipsets/
rm -f /usr/share/era/ipsets/*
for ipsetfile in `ls $IPSET_TMP_DIR/*.sh 2> /dev/null`; do
    filename=`basename $ipsetfile`
    grep -q '%' $ipsetfile
    if [ $? -eq 0 ];then
        CreoleCat -s $ipsetfile -o /usr/share/era/ipsets/$filename
    else
        cp -f $ipsetfile /usr/share/era/ipsets/$filename
    fi
    chmod +x /usr/share/era/ipsets/$filename
done

# lancement du script iptables
/sbin/lance.firewall #2>&1 | head -n 2
