# -*- coding: UTF-8 -*-
###########################################################################
#
# Eole NG
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  http://www.cecill.info/licences/Licence_CeCILL_V2-fr.html
# eole@ac-dijon.fr
#
###########################################################################

from era.noyau.objspace.flow.objspace import *
from era.noyau.pool import library_store
"""

    classes d'extension qui permettent de gérer le xml

"""

class __extend__(Extremite):

    def save(self, stream, indent = 0):
        """Méthode qui sauvegarde une extrémité au format interne
        stream : le flux dans lequel on écrit
        """
        # mise a jour des modeles en version 2.4
        # les extremites dans le bastion doivent etre de type conteneur
        # mais pas l'extremite bastion elle-même
        #if library_store.get_version() == 2.4 and
        if self.zone.name == u'bastion' and not self.name == u'bastion':
            if library_store.get_migration_flag():
                stream.write('%s<extremite zone="%s" name="%s" libelle="%s" netmask="%s" subnet="%d" type="conteneur" interface="eth1" container="%s">\n'% \
                    (" "*indent, self.zone.name, self.name, self.libelle, self.netmask, self.subnet, self.name.split("_")[0]))
            else:
                stream.write('%s<extremite zone="%s" name="%s" libelle="%s" netmask="%s" subnet="%d" type="conteneur" interface="%s" container="%s">\n'% \
                    (" "*indent, self.zone.name, self.name, self.libelle, self.netmask, self.subnet, self.interface, self.container_name))

        else:
            stream.write('%s<extremite zone="%s" name="%s" libelle="%s" netmask="%s" subnet="%d" type="%s" interface="%s" container="%s">\n'% \
                     (" "*indent, self.zone.name, self.name, self.libelle, self.netmask, self.subnet, self.extr_type, self.interface, self.container_name))
        for ip in self.ip_list:
            stream.write('%s<ip address="%s"/>\n'%(" "*(indent+4),ip))
        stream.write('%s</extremite>\n'%(" "*indent))

class __extend__(Directive):


    def save(self, stream, indent = 0):
        """Méthode qui sauvegarde une directive au format interne
        stream : le flux dans lequel on écrit
        """
        stream.write('%s<directive ' % (" "*indent, ) )
        if self.is_optional():
            try:
                stream.write('tag="%s" ' % self.tag)
            except:
                raise TagError, "une directive optionnelle n'a pas de tag"

        # si la directive est optionnelle, on regarde dans library_store.tags si le tag est actif ou caché
        try:
            if self.is_optional():
                if library_store.tags[str(self.tag)][0] == True:
                    self.attrs = self.attrs | DIRECTIVE_ACTIVE
                else:
                    self.attrs = self.attrs & 29
                if library_store.tags[str(self.tag)][1] == True:
                    self.attrs = self.attrs | DIRECTIVE_HIDDEN
                else:
                    self.attrs = self.attrs & 15
        except Exception, e:
            print "erreur : ",e

        stream.write('service="%s" priority="%d" action="%d" attrs="%d" ' % \
                     (self.service.name, self.priority, self.action, self.attrs)
                     )
        if self.app_group != None:
            stream.write('app_group="%s" ' % self.app_group)
        if self.user_group != None:
            stream.write('user_group="%s" ' % self.user_group.id)
        if self.mark != None:
            stream.write('mark_operator="%s" mark_value="%s" ' % (self.mark[0], self.mark[1]))

        if self.action > 2:
            #if self.action != 4:
            if self.nat_extr != None:
                stream.write('nat_extr="%s" '% (self.nat_extr.name))
            if self.nat_port != None:
                stream.write('nat_port="%s" '% (str(self.nat_port)))

        stream.write('src_inv="%d" dest_inv="%d" serv_inv="%d" libelle="%s" '% \
                         ( self.src_inv, self.dest_inv, self.serv_inv, self.libelle))
        stream.write('ipsec="{0}" '.format(str(self.ipsec)))
        stream.write('accept="{0}"'.format(str(self.accept)))
        if self.time != None:
            stream.write(' time="%s">\n' % self.time.name)
        else:
            stream.write('>\n')

        for src in self.src_list:
            stream.write('%s<source name="%s"/>\n'%(" "*(indent+4),src.name))
        for dest in self.dest_list:
            stream.write('%s<destination name="%s"/>\n'%(" "*(indent+4),dest.name))
        def bool_to_int(boolval):
            if boolval:
                return 1
            else:
                return 0
        for excp in self.exceptions:
            stream.write('%s<exception name="%s" ip="%s" eolvar="%s" src="%s" dest="%s"/>\n'%(
              " "*(indent+4), excp['name'], excp['ip'], excp['eolvar'],
              bool_to_int(excp['src']), bool_to_int(excp['dest'])))
        stream.write('%s</directive>\n'%(" "*indent))

class __extend__(Service):

    def save(self, stream, indent = 0):
        """Méthode qui sauvegarde un service au format interne
        stream : le flux dans lequel on écrit
        """
        port_str = self.port_list[0]
        if len(self.port_list) > 1:
            port_str = "%s-%s"%(self.port_list[0], self.port_list[-1])
        stream.write('%s<service name="%s" protocol="%s" ports="%s" id="%s" libelle="%s" tcpwrapper="%s"/>\n'% \
                     (" "*indent,self.name, self.protocol, port_str, self.id, self.libelle, self.tcpwrapper))


class __extend__(ServiceGroupe):

    def save(self, stream, indent = 0):
        """Méthode qui sauvegarde un groupe au format interne
        stream : le flux dans lequel on écrit
        """
        stream.write('%s<groupe id="%s" libelle="%s">\n'%(" "*indent, self.id, self.libelle))
        for service in self.services:
            service.save(stream, indent+4)
        stream.write('%s</groupe>\n'%(" "*indent))

class __extend__(UserGroup):

    def save(self, stream, indent = 0):
        """sauvegarde une zone au format xml
        stream: le flux dans lequel on écrit
        L{era.tests.test_user_xml.test_save_user_group}
        """
        stream.write('%s<user_group name="%s" id="%s"/>\n'% (" "*indent, self.name, self.id))

class __extend__(Zone):

    def save(self, stream, indent = 0):
        """Méthode qui sauvegarde une zone au format interne
        stream : le flux dans lequel on écrit
        L{era.tests.test_zone.test_save_zone}
        """
        stream.write('%s<zone name="%s" level="%d" ip="%s" network="%s" netmask="%s" interface="%s"/>\n'% \
                     (" "*indent, self.name, self.level, self.ip, self.network, self.netmask, self.interface))

class __extend__(Flux):

    def save(self, stream, indent = 0):
        """Méthode qui sauvegarde un flux au format interne
        stream : le flux dans lequel on écrit
        """
        stream.write('%s<flux zoneA="%s" zoneB="%s">\n'%(" "*indent,
                                                         self.zoneA.name, self.zoneB.name))
        stream.write('%s<montantes default_policy="%d">\n'%(" "*(indent+4), int(self.up_directives_store.default_policy)))
        #si la liste n'est pas vide, on la trie par ordre de priorité
        if len(self.up_directives_list()) > 0:
            self.up_directives_list().sort()

        for directive in self.up_directives_list():
            # permet d'eviter de sauver en double lors d'héritage
            if not directive.is_inherited():
                directive.save(stream, indent+8)

        stream.write('%s</montantes>\n'%(" "*(indent+4)))
        stream.write('%s<descendantes default_policy="%d">\n'%(" "*(indent+4) , int(self.down_directives_store.default_policy)))
        #si la liste n'est pas vide, on la trie par ordre de priorité
        if self.down_directives_list() > 0:
            self.down_directives_list().sort()

        for directive in self.down_directives_list():
            # permet d'eviter de sauver en double lors d'héritage
            if not directive.is_inherited():
                directive.save(stream, indent+8)

        stream.write('%s</descendantes>\n'%(" "*(indent+4)))
        stream.write('%s</flux>\n'%(" "*indent))

class __extend__(Range):

    def save(self, stream, indent = 0):
        """Méthode qui sauvegarde un service au format interne
        stream : le flux dans lequel on écrit
        """
        stream.write('%s<range name="%s"' % (" "*indent,self.name))
        if self.timestart != '':
            stream.write(' timestart="%s"' % self.timestart)
        if self.timestop != '':
            stream.write(' timestop="%s"' % self.timestop)
        if self.datestart != '':
            stream.write(' datestart="%s"' % self.datestart)
        if self.datestop != '':
            stream.write(' datestop="%s"' % self.datestop)
        if self.weekdays != '':
            stream.write(' weekdays="%s"' % self.weekdays)
        stream.write(' />\n')

class __extend__(ApplicationGroup):

    def save(self, stream, indent=2):
        """
            Sauvegarde en xml
            :stream: le flux dans lequel on écrit

        :return: xml string du type::

        <app_group name="browser" description="navigateur web">
            <app name="firefox"/>
            <app name="opera"/>
        </app_group>
        <app_group name="mail" description="client de messagerie">
            <app name="outlook"/>
            <app name="thunderbird"/>
        </app_group>

        """
        stream.write('%s<app_group name="%s" description="%s">\n'% (" "*indent, str(self.name), str(self.description)))
        for name in self.applications:
            stream.write('%s<app name="%s"/>\n'% ("  "*indent, str(name)))
        stream.write('%s</app_group>\n'% (" "*indent))

class __extend__(Application):

    def save(self, stream, indent=2):
        """
            sauvegarde en xml

            :stream: le flux dans lequel on écrit
            :return: xml string du type::

            <application name="firefox" description="navigateur web firefox">
              <path name="/usr/bin/firefox"/>
              <path name="/usr/share/firefox"/>
            </application>
        """
        stream.write('%s<application name="%s" description="%s">\n'% ("  "*indent, str(self.name), str(self.description)))
        for path in self.paths:
            stream.write('%s<path name="%s"/>\n'% ("  "*indent, str(path)))
        stream.write('%s</application>\n'% (" "*indent))

