# -*- coding: utf-8 -*-
"""high level compiler utility

module de compilation de haut niveau identique au *compiler* du backend
mais sans traduction ni fichiers d'options (regles optionnelles, regles cachées)

"""
import autopath
from os.path import join

from era.noyau.path import CONFIG_FILE
from era.backend.compiler import Compiler
from era.backend.iptwriter import IPTWriter
from era.noyau.initialize import initialize_app


def high_level_compile(model_fname, output_fname):
    """
    compilateur simple era (utile pour les tests)
    """
    matrix_model = initialize_app(model_fname)
    output = file(output_fname,'w')
    compiler = Compiler(IPTWriter, output, CONFIG_FILE)
    compiler.compile(matrix_model)
    output.close()

