# -*- coding: utf-8 -*-
###########################################################################
#
# Eole NG
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  http://www.cecill.info/licences/Licence_CeCILL_V2-fr.html
# eole@ac-dijon.fr
#
###########################################################################

"""generation de code cheetah sur des valeurs creole multivaluees"""

import re, sys
from creole.loader import creole_loader
#from era.backend.template import Template

loader = creole_loader()


class Multivar:
    """generation de code cheetah sur des valeurs multivaluees"""
    def __init__(self, lines=[]):
        """:lines: lignes iptables generees par le compilateur"""
        self.lines = lines

    def _getcreolevar_inline(self, line):
        """:return: la liste des variables creole dans une ligne
        """
        # regexp de motif %%mavariable[] ou mavariable[1]
        monovarregexp = re.compile('%%(\w*)\[[0-9]*\]')
        # regexp de motif %%mavariable
        multivarregexp = re.compile('%%(\w*)')

        # toute les variables templates sont parsees
        multivars = re.findall(multivarregexp, line)
        for var in multivars:
            # cette variable ne doit pas etre suivie de crochets
            if var not in re.findall(monovarregexp, line) and var != "calc_classe":
                yield var

    def process(self):
        """collecte les valeurs multivaluees dans le dictionaire creole
        """
        for line in self.lines:
            masters = {}
            tpline = line
            #utilisation d'un set pour n'obtenir qu'une occurence de chaque variable
            inline_vars = set(self._getcreolevar_inline(tpline))
            for var in inline_vars:
                try:
                    path = loader.creole.find_first(byname=var, type_='path')
                except AttributeError:
                    raise Exception("\n variable inconnue : " + var + " dans la regle : " + line + "\n")
                spath = path.split('.')
                opt = loader.unwrap_from_path(path)
                #it's a slave option
                if len(spath) == 4 and spath[2] != spath[3]:
                    master = spath[2]
                    #plusieurs esclaves de la même master
                    masters.setdefault(master, []).append(var)
                    tpline = tpline.replace("%%" + var, "%%_v_"+ master + '.' + var)
                elif opt.impl_is_multi():
                    #si c'est une master ou une multi isolée
                    #ou une "container_var"
                    #considère que c'est une master
                    masters.setdefault(var, [])
                    tpline = tpline.replace("%%" + var, "%%_v_"+ var)
                #else:
                #    # doubles % pour les variables non multi-valuees
                #    tpline = tpline.replace("%%" + var, "%%%%" + var)

            if masters != {}:
                #tpl = Template(masters=masters, template=tpline)
                # la ligne passee en parametre est le corps du template
                # il reste a la transformer en boucle for au sens cheetah
                for master in masters.keys():
                    tpline = """%for %%_v_{master} in %%{master}
{line}
%end for""".format(master=master, line=tpline)
                # pour qu'il n'y ait qu'une seule ligne a chaque fois -> split
                newline = tpline.split('\n')
                for n in newline:
                    yield n + '\n'
            else:
                yield line
