# -*- coding: utf-8 -*-
###########################################################################
#
# Eole NG
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  http://www.cecill.info/licences/Licence_CeCILL_V2-fr.html
# eole@ac-dijon.fr
#
###########################################################################

"""Module pour regrouper les petites fonctions utiles
"""

from __future__ import generators

__revision__ = '$Id: utils.py,v 1.1 2004/03/24 08:57:35 eole Exp $'


import types

def dump_port_range(port, sep = ':', inverted = False):
    """Fonction pour faciliter l'écriture des options relatives à des ports
     - sep est le caractère utilisé pour séparer les deux bornes de la rangée
     - inverted est un booléen qui définit si la rangée de ports doit être
       inversée ou non (<=> mettre le '!' ou pas)
    """
    # on teste si c'est un port unique ou bien une plage de ports
    if type(port) == types.IntType:
        return str(port)
    elif type(port) == types.ListType:
        if len(port) == 1:
            return str(port[0])
        else:
            # dport ne devrait être qu'une liste à 2 valeurs
            return '%s%s%s' % (port[0], sep, port[-1])
    else:
        return port

def gen_chains(zones, mirror = True):
    """Génère toutes les chaines à partir des zones
     - mirror : True si on doit aussi générer ped-ped, ext-ext, etc.
    """
    # Pas besoin de faire une copie, on ne modifie pas la liste
    for z1 in zones:
        for z2 in zones:
            # Hors mode 'miroir'
            if not mirror and z1.name == z2.name:
                continue
            yield '%s-%s' % (z1.name[:3], z2.name[:3])

def gen_chains_interface(zones, mirror = True):
    """Génère toutes les chaines à partir des zones,
     - mirror : True si on doit aussi générer ped-ped, ext-ext, etc.
    """
    # Pas besoin de faire une copie, on ne modifie pas la liste
    for z1 in zones:
        for z2 in zones:
            # Hors mode 'miroir'
            if not mirror and z1.name == z2.name:
                continue
            yield '%s-%s' % (z1.name[:3], z2.name[:3]) , z1.interface, z2.interface

def gen_couples(seq1, seq2):
    """Génère l'ensemble des couples possibles entre l1 et l2
    """
    for a in seq1:
        for b in seq2:
            yield a, b

def gen_ip_netmask(extrem):
    """Génère un couple ip / netmask à partir de l'extrémité
    Spécifités :
      - si extremite == exterieur => (0, 0)
      - si extremite <=> Toute la zone => (0, 0)
      - sinon : extrem.ip, extrem.netmask
    """
    #XXX duplicate in backend/processors.build_container_rule()
    e_name = extrem.name.lower()
    if e_name == 'exterieur' or extrem.all_zone:
        yield ('0', '0')
    else:
        for ip in extrem.ip_list:
            yield (ip, extrem.netmask)

def gen_ip_couples(from_extrem, dest_extrem):
    """Génère l'ensemble des combinaisons ip / netmask entre les 2 extrémités
    Cette fonction *NE GERE PAS* le cas 'bastion'
    """
    assert from_extrem.name.lower() != 'bastion' and \
           dest_extrem.name.lower() != 'bastion'
    for f_ip, f_netmask in gen_ip_netmask(from_extrem):
        for d_ip, d_netmask in gen_ip_netmask(dest_extrem):
            yield (f_ip, f_netmask, d_ip, d_netmask)

class LStringIO(list):
    """petite classe qui émule write et getvalue
    en utilisant des listes
    """
    write = list.append
    def getvalue(self, join_char = ''):
        return join_char.join(self)
