# -*- coding: utf-8 -*- 
"""

tests de haut niveau concernant le backend era, 
c'est à dire que les tests concernent 
- un fichier d'entrée 
- un fichier de sortie

"""

import autopath
from os.path import join 
from era.tests.hlcompile import high_level_compile as compiler
from era.tests.utils import TempFile

from era.noyau.initialize import initialize_app

def test_compile():
    """
    ce test est surtout là pour voir que le compiler se lance
    et produit bien un résultat
    """
    tp = TempFile()
    model_file = join(autopath.HERE, "data", "hlcompiler.xml")
    compiler(model_file, tp.tmpfname)
    assert "iptables" in tp.read()
    tp.clean()

def test_static_rules():
    "static rules have special characters (entities) that have to be escaped"
    tp = TempFile()
    model_file = join(autopath.HERE, "data", "includes.xml")
    compiler(model_file, tp.tmpfname)
    assert "bla bla static includes & < >   bla bla sdfsdfsdf sdfsdf" in tp.read()
    tp.clean()
    
def test_save_static_rules():
    "static rules are saved with escaped characters now"
    tp = TempFile()
    model_file = join(autopath.HERE, "data", "includes.xml")
    matrix_model = initialize_app(model_file)
    tpout = TempFile()
    matrix_model.save(tpout.tmpfname) 
    tp.clean()
    assert "bla bla static includes &amp; &lt; &gt;   bla bla sdfsdfsdf sdfsdf" in tpout.read()
    tpout.clean()
        
        
