#!/usr/bin/env python
# -*- coding: utf-8 -*-
"""
script de génération des templates
"""
from os.path import dirname, abspath, join, normpath, basename, isdir
from os import makedirs
from glob import glob

try:
    from era.noyau.merge import main
except:
    #lors de la compile, le répertoire s'appelle era-2.3 donc supprime cette
    #partie
    from noyau.merge import main

HERE = dirname(abspath(__file__))
ERAPATH = normpath(join(HERE, '..'))
TEMPLATE_PATH = join(ERAPATH, 'templates')
SUBTEMPLATE_PATH = join(TEMPLATE_PATH, 'subtmpl')
ABSTRACT_PATH = join(SUBTEMPLATE_PATH, 'abstract')
MODELES_PATH = join(ERAPATH, 'modeles')

templates = glob(join(TEMPLATE_PATH, '*.xml'))

# ____________________________________________________________
# instantiaction des templates abstraits en templates

def instanciate_abstract_tmpl(abstract_fname, tmpl_fname, instvars):
    print "abstract generating: {0}".format(tmpl_fname)
    fh = file(abstract_fname, 'r')
    abstract_content = fh.read()
    fh.close()
    # transform
    abstract_content = abstract_content.format(**instvars)
    fh = file(tmpl_fname, 'w')
    fh.write(abstract_content)
    fh.close()
# ____________________________________________________________
# pedago
abstract_dmz_fname = join(ABSTRACT_PATH, 'pedago.xml')
tmpl_dmz_fname = join(SUBTEMPLATE_PATH, 'pedago-eth1.xml')
instanciate_abstract_tmpl(abstract_dmz_fname, tmpl_dmz_fname, {'ZONENUM': '1'})
tmpl_dmz_fname = join(SUBTEMPLATE_PATH, 'pedago-eth2.xml')
instanciate_abstract_tmpl(abstract_dmz_fname, tmpl_dmz_fname, {'ZONENUM': '2'})
# ____________________________________________________________
# dmz
abstract_dmz_fname = join(ABSTRACT_PATH, 'dmz.xml')
tmpl_dmz_fname = join(SUBTEMPLATE_PATH, 'dmz-eth2.xml')
instanciate_abstract_tmpl(abstract_dmz_fname, tmpl_dmz_fname, {'NAME': 'dmz', 'NUM': '2', 'LEVEL': '30'})
tmpl_dmz_fname = join(SUBTEMPLATE_PATH, 'dmz-eth3.xml')
instanciate_abstract_tmpl(abstract_dmz_fname, tmpl_dmz_fname, {'NAME': 'dmz', 'NUM': '3', 'LEVEL': '30'})
tmpl_dmz_fname = join(SUBTEMPLATE_PATH, 'privdmz-eth3.xml')
instanciate_abstract_tmpl(abstract_dmz_fname, tmpl_dmz_fname, {'NAME': 'privdmz', 'NUM': '3', 'LEVEL': '30'})
tmpl_dmz_fname = join(SUBTEMPLATE_PATH, 'pubdmz-eth4.xml')
instanciate_abstract_tmpl(abstract_dmz_fname, tmpl_dmz_fname, {'NAME': 'pubdmz', 'NUM': '4', 'LEVEL': '20'})

# ____________________________________________________________
# dmz-scribe
abstract_dmz_fname = join(ABSTRACT_PATH, 'dmz-scribe.xml')
tmpl_dmz_fname = join(SUBTEMPLATE_PATH, 'dmz-scribe-eth2.xml')
instanciate_abstract_tmpl(abstract_dmz_fname, tmpl_dmz_fname, {'ZONENUM': '2', 'ZONENAME': 'pedago', 'DMZNAME':'dmz'})
tmpl_dmz_fname = join(SUBTEMPLATE_PATH, 'dmz-scribe-eth3.xml')
instanciate_abstract_tmpl(abstract_dmz_fname, tmpl_dmz_fname, {'ZONENUM': '3', 'ZONENAME': 'pedago', 'DMZNAME':'dmz'})
tmpl_dmz_fname = join(SUBTEMPLATE_PATH, 'privdmz-scribe-eth3.xml')
instanciate_abstract_tmpl(abstract_dmz_fname, tmpl_dmz_fname, {'DMZNAME': 'privdmz', 'ZONENAME': 'pedago', 'ZONENUM':3})

# ____________________________________________________________
# instanciation des templates en modèles
for template in templates:
    if not isdir(MODELES_PATH):
        makedirs(MODELES_PATH)
    modele = join(MODELES_PATH, basename(template))
    print "generating: {0}".format(modele)
    fh = file(modele, 'w')
    fh.write(main(template))
    fh.close()



