# -*- coding: UTF-8 -*-

"""
Tests unitaires de parsing de la lib par défaut
"""
from os.path import join

import autopath
from era.noyau.erreurs import *
from era.noyau.fwobjects import *
from era.noyau.models import *
from era.noyau.initialize import *

from era.noyau.pool import library_store
from era.noyau.models import MatrixModel

    
def test_parse_service_file():
    """Charge les services depuis un fichier xml et 
    verifie que les services sont bien presents dans le library_store
    L{era.noyau.domparsers.parse_service_file}
    """
    serv1 = Service("serv1", "tcp", ['8080'],
                                 "test1", "ce service est un test")
    s_list, g_list = parse_service_file(join(autopath.HERE, "data", "services.xml"))
    library_store.services = s_list
    assert library_store.services[0] == serv1

def test_parse_service_groupes():
    """Charge les groupes de services et 
    verifie qu'ils sont bien dans le library_store
    L{era.noyau.domparsers.parse_service_file}
    """
    s_list, g_list = parse_service_file(join(autopath.HERE, "data","services.xml"))
    library_store.groups = g_list
    assert library_store.groups[0].id == "groupe1"

def test_parse_zone_file():
    """Charge les zones a partir d'un fichier 
    et verifie que les zones sont bien dans MatrixModel
    L{era.noyau.domparsers.parse_zone_file}
    """
    zone1 = Zone( "bastion", "100", "127.0.0.1", "0.0.0.0",
             "255.255.255.255", "lo")
    matrix_model = MatrixModel()
    zone_list = parse_zone_file(join(autopath.HERE, "data","zones.xml"))
    matrix_model.add_zone(zone_list[0])
    assert matrix_model.zones[0] == zone1
