from xml.etree import ElementTree as ET
from xml.etree.ElementTree import tostring

def add(flux1, flux2):
    """accumulte flux2 sur flux1 sans test d'unicite 
    # FIXME but with sorted directives

    flux1 = [d1, d2]
    flux2 = [d'1, d'2]
    d'1 becomes d3
    d'2 becomes d4
    add(flux1, flux2) = [d1, d2, d3, d4]

    """
    montantes = flux1.find('montantes')
    len_montantes1 = len(flux1.findall('montantes/directive'))
    montantes2 = flux2.findall('montantes/directive')
    sorted_montantes2 = sorted(montantes2, key=lambda directive: int(directive.get('priority')))  
    for directive in sorted_montantes2:
        priority = str(len_montantes1 + sorted_montantes2.index(directive) + 1)
        directive.set('priority', priority)
        montantes.append(directive)
    descendantes = flux1.find('descendantes')
    for directive in flux2.findall('descendantes/directive'):
        descendantes.append(directive)

def complementary_flux(flux1, flux2):
    """returns: flux list. Les flux qui sont dans flux2 mais pas dans flux1
    """
    existing_flux = []
    complementary = []

    for flx in flux1:
        existing_flux.append( (flx.get('zoneA'), flx.get('zoneB')) )

    for flx in flux2:
        zoneA = flx.get('zoneA')
        zoneB = flx.get('zoneB')
        if (zoneA, zoneB) not in existing_flux:
            complementary.append(flx)

    return complementary    

def main(fname1, fname2):
    """point d'entree 
    parsing des deux fichiers xml
    """
    fw1 = parse_fw(fname1)
    fw2 = parse_fw(fname2)
    firewall_rootelt(fw1, fw2)

def firewall_rootelt(fw1, fw2):
    """make root element"""
    root = ET.Element("firewall")
    root.text = '\n    '
    # FIXME : c'est le **fw2** qui dirige les options
    root.attrib.update(fw2.attrib)
    # generated name
    root.attrib['name'] = "Concatenated_Do_Not_Edit"
    # ____________________________________________________________
    # ajout des zones
    zones = fw1.findall("zones/zone")
    for zone in fw2.findall("zones/zone"):
        if zone.get('name') not in [z.get('name') for z in zones]:
            zones.append(zone)

    zone_root = ET.SubElement(root, "zones")
    zone_root.text = "\n        "
    for zone in zones:
        zone_root.append(zone)
    # ____________________________________________________________
    # add services
    service_root = ET.SubElement(root, "services")
    service_root.text = "\n        "
    for serv in fw1.findall('services/service'):
        service_root.append(serv)
    for serv in fw2.findall('services/service'):
        service_root.append(serv)
    
    # ____________________________________________________________
    # extremites
    extremite_root = ET.SubElement(root, "extremites")
    extremite_root.text = "\n        "    
    for serv in fw1.findall('extremites/extremite'):
        extremite_root.append(serv)
    for serv in fw2.findall('extremites/extremite'):
        extremite_root.append(serv)
    # ____________________________________________________________
    # ranges
    ranges_root = ET.SubElement(root, "ranges")
    ranges_root.text = "\n        "
    for serv in fw1.findall('ranges/range'):
        ranges_root.append(serv)
    for serv in fw2.findall('ranges/range'):
        ranges_root.append(serv)

    # ____________________________________________________________
    # user_group
    user_root = ET.SubElement(root, "user_groups")
    user_root.text = "\n        "
    for serv in fw1.findall('user_groups/user_group'):
        user_root.append(serv)
    for serv in fw2.findall('user_groups/user_group'):
        user_root.append(serv)

    # ____________________________________________________________
    # flux 
    flux_root = ET.SubElement(root, "flux-list")
    flux_root.text = "\n        "

    flux1 = fw1.findall('flux-list/flux')
    flux2 = fw2.findall('flux-list/flux')
    different_flux =  complementary_flux(flux1, flux2)
    # accumulation des flux identiques
    for fx1 in flux1:
        for fx2 in flux2:
            if fx1.get('zoneA') == fx2.get('zoneA') and fx1.get('zoneB') == fx2.get('zoneB'):
                add(fx1, fx2)

    for flx in flux1:
        flux_root.append(flx)
        
    # ajout des flux complementaires
    for flx in different_flux:
        flux_root.append(flx)            

    # ____________________________________________________________
    #pi = ET.ProcessingInstruction("xml", text='version="1.0" encoding="UTF-8"')
    #tree = ET.ElementTree(root)
    #tree.write("mergedoutput.xml")

    # ____________________________________________________________
    # output
    # remplace les apostrophes-entities par des apostrophes -> pas du "vrai" xml
    print '<?xml version="1.0" encoding="UTF-8" ?>\n' + tostring(root, encoding='utf-8').replace('&apos;', "'") 

def parse_fw(fname):
    xml = ET.parse(fname)
    firewall = xml.getroot()
    return firewall
    
if __name__ == '__main__':
    import sys
    fname1 = sys.argv[1]
    fname2 = sys.argv[2]
    main(fname1, fname2)

