## Reinitialisation des chaines
/sbin/iptables -F
/sbin/iptables -t nat -F
/sbin/iptables -t mangle -F

## on vide les regles utilisateurs
/sbin/iptables -X
/sbin/iptables -t nat -X
/sbin/iptables -t mangle -X

# flush des règles ipsets
ipset --list |grep ^"Name: bastion-" | while read name; do
    name="${name#Name: *}"
    ipset -F $name
    ipset -X $name
done

## mise en place de la politique par defaut
/sbin/iptables -P INPUT DROP
/sbin/iptables -P OUTPUT ACCEPT
/sbin/iptables -P FORWARD DROP
## on change la politique par defaut du nat
/sbin/iptables -t nat -P PREROUTING ACCEPT
/sbin/iptables -t nat -P POSTROUTING ACCEPT

### Chargement des modules

## Charger le module NAT
modprobe iptable_nat

## Charger le module TIME
modprobe ipt_time

## activer l'anti-spoofing
echo 1 > /proc/sys/net/ipv4/conf/all/rp_filter

## Activer le passage IP
echo 1 > /proc/sys/net/ipv4/ip_forward

## inserer le module ftp
modprobe ip_nat_ftp

## Insere les modules de suivie de connexion
modprobe ip_conntrack
modprobe ip_conntrack_ftp

## inserer le module tftp

modprobe ip_nat_tftp

#-------------------------------------------------------------------------------------------

### loopback

## traffic illimite autorise sur l'interface locale
/sbin/iptables -A INPUT -i lo -j ACCEPT
/sbin/iptables -A OUTPUT -o lo -j ACCEPT

#----------------------------------------------------------------------------------------

## creation de la chaine icmp accept
/sbin/iptables -N icmp-acc
## creation de la chaine marquage
/sbin/iptables -t mangle -N marquage
## definition de la chaine icmp-acc
/sbin/iptables -A icmp-acc -p icmp --icmp-type destination-unreachable -j ACCEPT
/sbin/iptables -A icmp-acc -p icmp --icmp-type source-quench -j ACCEPT
/sbin/iptables -A icmp-acc -p icmp --icmp-type time-exceeded -j ACCEPT
/sbin/iptables -A icmp-acc -p icmp --icmp-type parameter-problem -j ACCEPT
/sbin/iptables -A icmp-acc -p icmp --icmp-type echo-reply -j ACCEPT

## Creation chaine netbios-ext
/sbin/iptables -t filter -N netbios-ext
/sbin/iptables -t filter -A netbios-ext -p tcp --dport 135 -j DROP
/sbin/iptables -t filter -A netbios-ext -p udp --dport 135 -j DROP
/sbin/iptables -t filter -A netbios-ext -p tcp --dport 137:139 -j DROP
/sbin/iptables -t filter -A netbios-ext -p udp --dport 137:139 -j DROP
/sbin/iptables -t filter -A netbios-ext -p tcp --dport 445 -j DROP
/sbin/iptables -t filter -A netbios-ext -p udp --dport 445 -j DROP

for script in `ls /usr/share/era/ipsets/*.sh 2> /dev/null`; do
    $script
done
