# -*- coding: utf-8 -*-
###########################################################################
#
# Eole NG
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  http://www.cecill.info/licences/Licence_CeCILL_V2-fr.html
# eole@ac-dijon.fr
#
###########################################################################

"""Simple API pour écrire des règles iptables"""

import sys

#class IRuleWriter(object):
#    """Interface de base pour les classes d'écriture des règles
#    """

#    def comment(self, comment, level = 1):
#        """Ajoute un commentaire
#         - comment : le commentaire à ajouter
#         - level = le niveau de commentaire (1 = le plus faible)
#        """
#        raise NotImplementedError()

#    def append_rule(self, rule):
#        """Ajoute une règle dans la table passée en paramètres
#        """
#        raise NotImplementedError()

###     def insert_rule(self, rule, position):
###         """Insère une règle à la position 'position'
###         """
###         raise NotImplementedError()


class IPTWriter(object):
    """Définit une interface d'écriture de règles iptables
    implémente IRuleWriter
    """
    def __init__(self, exec_path = '/sbin/iptables', output = sys.stdout):
        """
         - exec_path : le chemin d'accès à l'éxécutable *iptables*
           (valeur par défaut = '/sbin/iptables')
         - output : où les règles seront écrites
           (valeur par défaut = sys.stdout)
        """
        self.exec_path = exec_path
        self.output = output


    def comment(self, comment, level = 1):
        """Ajoute un commentaire dans le fichier iptables
        """
        pass
        #self.output.write('%s %s \n' % ('#' * level, comment))

    def new_chain(self, chain_name, table = 'filter'):
        """Ajout d'une nouvelle chaine
        L{era.tests.test_writer.test_new_chain}
        """
        if self.output.iptables_restore:
            self.output.append_table(table, ':%s - [0:0]\n' % chain_name)
        else:
            self.output.append_table(table, '-N %s\n' % chain_name)


#    def delete_chain(self, chain_name, table = 'filter'):
#        """Suppression d'une chaine
#        L{era.tests.test_writer.test_delete_chain}
#        """
#        self.output.write('%s -t %s -X %s\n' % (self.exec_path,
#                                              table,
#                                              chain_name))
#
#    def flush_chain(self, chain_name, table = 'filter'):
#        """Vide une chaine de toutes ses règles
#        L{era.tests.test_writer.test_flush_chain}
#        """
#        self.output.write('%s -t %s -F %s\n' % (self.exec_path,
#                                              table,
#                                              chain_name))

    def append_rule_from_params(self, chain_name, table_name,
                                parameters, target = None):
        """Ajoute une règle dans la table passée en paramètres
        target: une instance d'une classe dérivée de IPTTarget
        L{era.tests.test_writer.test_basic_append}
        """
        option_list = [str(param) for param in parameters]
        if option_list:
            options_str = ' '.join(option_list) + ' '
        else:
            options_str = ''

        table_name = table_name or 'filter'
        if chain_name:
            rule = '-A %s %s%s\n' % (chain_name,
                                     options_str,
                                     target or '')
        else:
            rule = '%s%s\n' % (options_str,
                               target or '')
        self.output.append_table(table_name, rule)


    def append_rule(self, rule):
        """Ajoute une règle iptables
         - rule doit être une instance de IPTRule
        """
        self.append_rule_from_params(rule.chain_name, rule.table_name,
                                     rule.params, rule.target)

#    def append_filter_rule(self, chain_name, parameters = None, target = None):
#        """Ajoute une règle à la table *filter*
#        (Définie pour convenance)
#         - parameters est une liste d'instance de ParametersOptions
#        """
#        self.append_rule(chain_name, 'filter', parameters, target)
#
#
#    def append_nat_rule(self, chain_name, parameters = None, target = None):
#        """Ajoute une règle à la table *nat*
#        (Définie pour convenance)
#        """
#        self.append_rule(chain_name, 'nat', parameters, target)
#
#
#    def append_mangle_rule(self, chain_name, parameters = None, target = None):
#        """Ajoute une règle à la table *mangle*
#        (Définie pour convenance)
#        """
#        self.append_rule(chain_name, 'mangle', parameters, target)
#
