# -*- coding: utf-8 -*-
"""
    utilisation en mode standalone
"""
import gtk 

class UnspecifiedVarsDialog(gtk.Dialog):
    def __init__(self, varnames, parent):
        # on construit un dialogue avec OK / Cancel
        gtk.Dialog.__init__(self, _('missing fields'), parent, gtk.DIALOG_MODAL,
                            (gtk.STOCK_OK, gtk.RESPONSE_ACCEPT,
                             gtk.STOCK_CANCEL, gtk.RESPONSE_REJECT))
        fields_table = gtk.Table(len(varnames), 2)
        fields_table.set_col_spacings(3)
        # dictionnaire nom_de_variable / widget gtk associé
        self.entries = {}
        for row, varname in enumerate(varnames):
            label = gtk.Label(varname)
            entry = gtk.Entry()
            entry.connect('changed', self.on_form_changed)
            fields_table.attach(label, 0, 1, row, row+1)
            fields_table.attach(entry, 1, 2, row, row+1)
            self.entries[varname] = entry
        self.vbox.pack_start(fields_table)
        self.set_response_sensitive(gtk.RESPONSE_ACCEPT, False)

    def get_values(self):
        """renvoie l'ensemble des champs saisis sous forme
        de dictionnaire variable / valeur
        """
        return dict( [(varname, entry.get_text())
                      for varname, entry in self.entries.iteritems()] )

    def on_form_changed(self, *args):
        """appelé à chaque changement dans le formulaire pour mettre à jour
        le bouton OK
        """
        acceptable = all([entry.get_text() for entry in self.entries.values()])
        self.set_response_sensitive(gtk.RESPONSE_ACCEPT, acceptable)
 
def ask_for_unspecified_vars(varnames, parent=None):
    """affiche un popup pour saisir les variables non-instanciées

    @param varnames : l'ensemble des variables à renseigner
    @param parent : fenêtre parente (au sens GTK) si besoin
    @returns un dictionnaire variable / valeur 
    """
    dlg = UnspecifiedVarsDialog(varnames, parent)
    dlg.show_all()
    response = dlg.run()
    if response == gtk.RESPONSE_ACCEPT:
        variables = dlg.get_values()
    else:
        variables = None
    dlg.destroy()
    return variables

