# -*- coding: UTF-8 -*-
"""

Test des règles netbios
# FIXME : gérer **tous** les cas (netbios active, desactive...)
"""
import autopath

from os.path import dirname, abspath, splitext, basename, join
from xml.dom.minidom import parseString

from era.backend.iptwriter import IPTWriter
from era.tests.utils import LStringIO, purge_list
from era.backend.compiler import Compiler
from era.noyau.initialize import parse_firewall_file

from utils import LStringIO
# lancement de l'appliquation
from era.backend.compiler import Compiler
from era.backend.iptwriter import IPTWriter

from era.noyau.initialize import initialize_app


def test_netbios():
    "presence et recuperation de l'attribut netbios dans le xml, netbios actif"
    model_file = join(autopath.HERE, "data", "test_netbios.xml")
    
    fwobjs = parse_firewall_file(model_file)
    netbios = fwobjs['netbios']
#    zones, flux_list, extremites, services, groups, rules, netbios , ranges, model, user_groups, qos, options = parse_firewall_file(model_file)
    assert netbios == 1

def test_netbios_non_present():
    "non presence de l'attribut netbios dans le xml"
    model_file = join(autopath.HERE, "data", "test_netbios_non_present.xml")
    fwobjs = parse_firewall_file(model_file)
    netbios = fwobjs['netbios']
#    zones, flux_list, extremites, services, groups, rules, netbios , ranges, model, user_groups, qos, options = parse_firewall_file(model_file)
    assert netbios == 1


def test_netbios_false():
    "presence et recuperation de l'attribut netbios dans le xml, netbios inactif"
    model_file = join(autopath.HERE, "data", "test_netbios_false.xml")
#    zones, flux_list, extremites, services, groups, rules, netbios , ranges, model, user_groups, qos, options = parse_firewall_file(model_file)
    fwobjs = parse_firewall_file(model_file)
    netbios = fwobjs['netbios']
    assert netbios == 0

def test_netbios_fields():
    """ Présence des règles netbios générées
    """
    matrix_model = initialize_app( join(autopath.HERE, "data", "test_netbios.xml") )
    
    output = LStringIO()
    compiler = Compiler(IPTWriter, output, join(autopath.HERE, "data", 'config_netbios.ini'))
    writer = IPTWriter(output = output)

    compiler.compile(matrix_model)
    sortie = output.filter()
    result = "".join(sortie)
    DEFAULT_NETBIOS_POLICY = "/sbin/iptables -t filter -A FORWARD -o %%interface_gw%% -j netbios-ext"
    # NETBIOS_POLICY_TARGET = "-j netbios-ext"
    assert DEFAULT_NETBIOS_POLICY in result    



def test_netbios_fields_non_present():
    """ Les règles netbios générées ne sont pas présentes (netbios desactive)
    """
    matrix_model = initialize_app( join(autopath.HERE, "data", "test_netbios_false.xml") )
    
    output = LStringIO()
    compiler = Compiler(IPTWriter, output, join(autopath.HERE, "data", 'config_netbios.ini'))
    writer = IPTWriter(output = output)

    compiler.compile(matrix_model)
    sortie = output.filter()
    result = "".join(sortie)
#     DEFAULT_NETBIOS_POLICY = "/sbin/iptables -t filter -A FORWARD -o %%interface_gw%% -j netbios-ext"
    # NETBIOS_POLICY_TARGET = "-j netbios-ext"
    assert "netbios-ext" not in result    

