# -*- coding: UTF-8 -*-
"""Module de tests unitaires pour l'écriture des règles iptables"""
from os.path import isfile, join
import autopath
from StringIO import StringIO
from era.noyau.initialize import initialize_app
from era.backend.compiler import Output
from era.backend.processors import get_processor
from era.backend.iptwriter import IPTWriter


class RulesGenerator(object):
    def __init__(self, xmlfname):
        """

        :param xmlfname: should be only one directive in the xml
        """
        self.xmlfname = xmlfname
        self.fw_file = join(autopath.HERE, "data", self.xmlfname) #'input-output2.xml')
        if not isfile(self.fw_file):
            raise IOError("file not found : {}".format(xmlfname))
        self.mmodel = initialize_app(self.fw_file)

        self.generate_rules()

    def generate_rules(self):
        # should be only one directive to be tested
        self.rules = []
        self.implicit_rules = []
        for directive in self.mmodel.directive_collector():
            proc = get_processor(directive)
            self.rules.extend(proc.process())
            self.implicit_rules.extend(proc.get_implicit_rules())

    def generate_iptables(self):
        self.output = Output()
        writer = IPTWriter(output=self.output)
        for rule in self.rules:
            writer.append_rule(rule)
        return self.output.getvalue()

    def generate_implicit_iptables(self):
        # output should be empty for the standard directives (ACCEPT, DROP...)
        self.output = StringIO()
        writer = IPTWriter(output=self.output)
        for rule in self.implicit_rules:
            writer.append_rule(rule)
        return self.output.getvalue()

def test_rules_gen():

    r = RulesGenerator('input-output2.xml')
    print r.generate_iptables()
    print r.generate_implicit_iptables()

