# -*- coding: UTF-8 -*-
"""utilitaires de tests
"""
import autopath

from xml.dom.minidom import parseString, parse
from era.noyau import domparsers

from era.noyau.fwobjects import Zone,  Service, ServiceGroupe, Extremite, Directive, Flux, Range


from era.backend.processors import get_processor
from era.backend.iptwriter import IPTWriter

import tempfile
from os import unlink, close

class TempFile:
    """
    class permettant la gestion de fichiers temporaires
    """
    def __init__(self):
        self.fdescr, self.tmpfname = tempfile.mkstemp()

    def write(self, writestr):
        "ecriture"
        self.tmpfh = file(self.tmpfname, 'w')
        self.tmpfh.write(writestr)
        self.tmpfh.close()

    def read(self):
        "lecture"
        self.tmpfh = file(self.tmpfname, 'r')
        buffer = self.tmpfh.read()
        self.tmpfh.close()
        return buffer

    def clean(self):
        close(self.fdescr)
        unlink(self.tmpfname)

class LStringIO(list):
    """petite classe qui émule write et getvalue
    en utilisant des listes
    """
    write = list.append
    def getvalue(self, join_char = ''):
        # pour remettre le type string partout (aparemment il y a de l'unicode aussi)
        l = []
        for i in self:
            l.append(str(i))
        return join_char.join(l)

    def filter(self):
        l = []
        for i in self:
            l.append(str(i))
        return l


class GenDirective:
    """
    dir_node = xml_string
    d = GenDirective(dir_node)
    print d.gen_directive()
    """

    def __init__(self, dir_node):
        self.dir_node = dir_node
        self._init_zones()
        self._init_extremites()
        self._init_services()
        self._init_ranges()
        self.directive = self._gen_directive()


    def _init_zones(self):

        zoneA = Zone('zoneA', 30, '127.0.0.1')
        zoneB = Zone('zoneB', 31, '127.0.0.1')
        zoneC = Zone('zoneC', 32, '127.0.0.1')
        self.zones = {'zoneA': zoneA,
                 'zoneB': zoneB,
                 'zoneC': zoneC
                 }

    def _init_extremites(self):
        e1 = Extremite(self.zones['zoneA'],"extr1", "libelle1", ["10.0.0.1"], "255.255.255.255")
        e2 = Extremite(self.zones['zoneA'],"extr2", "libelle2", ["10.0.0.2"], "255.255.255.255")
        e3 = Extremite(self.zones['zoneB'],"extr3", "libelle3", ["10.0.0.3"], "255.255.255.255")
        e4 = Extremite(self.zones['zoneC'],"extr4", "libelle4", ["10.0.0.4"], "255.255.255.255")
        self.extremites = {"extr1" : e1,"extr2" : e2,"extr3" : e3,"extr4" : e4}

    def _init_services(self):
        s1 = Service("serv1", "TCP", [80], "serv1", "libelle_Internet")
        s2 = Service("serv1", "TCP", [480], "serv2", "libelle2")
        s3 = Service("Youpi", "UDP", [4513], "serv3", "libelle3")
        s4 = ServiceGroupe("Groupe1", "test de groupe de srevices",[s1,s2])
        self.services = {"serv1" : s1, "serv2" : s2, "Youpi" : s3}
        self.groups = {"Group1" : s4}

    def _init_ranges(self):
        r1 = Range({'name':"range1", 'timestart':'02:00', 'timestop':'19:00'})
        r2 = Range({'name':"range1", 'days': 'Mon,Tue'})
        self.ranges = {"range1": r1, "range2": r2}

    def _gen_directive(self):
        """That is why all this stuff is about
        """
        doc = parseString(self.dir_node)

        return domparsers.instantiate_directive_from_dom(doc.firstChild,
                                              self.extremites, self.services, self.groups, self.ranges)

    def get_rules(self):
        """Sort le script iptables proprement dit
        """
        _writer = IPTWriter(output= LStringIO())
        # directive = selft.gen_directive()
        proc = get_processor(self.directive)
        rules = proc.process()
        for rule in rules:
            _writer.append_rule(rule)

        return _writer.output.getvalue()

    def get_implicit_rules(self):
        """Sort le script iptables proprement dit
        """
        _writer = IPTWriter(output= LStringIO())
        # directive = selft.gen_directive()
        proc = get_processor(self.directive)
        rules = proc.process()
        implicit_rules = proc.get_implicit_rules()

        for rule in implicit_rules:
            _writer.append_rule(rule)

        return _writer.output.getvalue()



#     def process_directive(self):
#         """Teste le statut (optionnel, actif, inactif)
#         de la directive, ressort (éventuellement) de l'iptables
#         """
#         if directive.is_active() or not directive.is_optional():
#             _writer = IPTWriter(output= LStringIO())
#             # directive = selft.gen_directive()
#             proc = get_processor(self.directive)
#             rules = proc.process()
#             for rule in rules:
#                 _writer.append_rule(rule)

#             return _writer.output.getvalue()

#         else return ""


def check_output(expected, output):
    """Routine de vérification commune à presque tous les tests
     - Enlève les commentaires et trie la sortie du compilateur
     - Trie le résultat attendu
     - Compare les deux :
       - si identiques : OK
       - sinon, lève une AssertionError avec la première différence trouvée
    """
    uncommented = purge_list(output)
    uncommented.sort()
    expected.sort()
    first_diff = get_first_diff(uncommented, expected)
    if first_diff:
        self.assert_(uncommented == expected,
                     'Index %s, GOT :\n%s\nEXPECTED :\n%s' % first_diff)

def purge_list(list_io):
    """Remove comment and blank lines"""
    purged = []
    for line in list_io:
        line = line.strip()
        if line and not line.startswith('#'):
            purged.append(line.split(' -m comment')[0])
    return purged

def get_first_diff(seq1, seq2):
    """Renvoie un tuple index, valeur de la première différence trouvée"""
    if seq1 == [] or seq2 == []:
        return 0, seq1, seq2
    for index, (val1, val2) in enumerate(zip(seq1, seq2)):
        if val1 != val2:
            return index, val1, val2
    return None


# # On définit "enumerate" si on est dans python < 2.3
# py_version = sys.version_info[:2]
# if py_version < (2, 3):
#     def enumerate(seq):
#         """émulation du builtin enumerate de pyhon2.3"""
#         return [(index, seq[index]) for index in range(len(seq))]

def compare_dicts(expected, output):
    """
    Compare deux dictionaires:
    - suivant leurs clefs
    - si des valeurs de ce qui est attendu sont dans ce qui est sorti
    @param output: la sortie du test
    @param expected: ce qui est attendu
    @return: True, False
    """
    for key, value in expected.items():
        if key not in output.keys():
            return False
        if value not in expected[key]:
            return False
    return True
