# -*- coding: utf-8 -*- 
###########################################################################
# 
# Eole NG  
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  http://www.cecill.info/licences/Licence_CeCILL_V2-fr.html
# eole@ac-dijon.fr 
#  
###########################################################################

"""utilitaires de gestion de la qos externe 
pour la génération du fichier de qos"""
import sys
from era.noyau import initialize
from era.noyau.pool import library_store

QOSRULES_TEMPLATE = """#---------------------------------------------------
# ERA external qos auto generated file - please do not edit ! 
#---------------------------------------------------
# fichier de qos externe genere par era - priere de ne pas editer ! 
#---------------------------------------------------

# VARIABLES DE CONFIGURATION 

NB_Inter=%(nb_cards)s

# DEBITS Internet en kbits (mettre un peu en dessous des debits reels)

DOWN=%(download_bandwidth)s
UP=%(upload_bandwidth)s

# TAUX minimum  (en pourcentage) 
# Attention: le cumul des taux < = 100 pourcent ! #

#Par defaut la carte eth0 est la sortie sur Internet.
#Le taux donne a cette carte correspond aux services installes sur Amon, c'est a dire essentiellement le proxy Web.
%(percent_int)s
"""
from os import unlink

def zone_to_ethnb(zone_name):
    for zone in zones:
        if zone.name == zone_name:
            return zone.interface[-1:]
    raise Exception, "zone non trouvee"

def get_qos_classes(model_file, qos_file=None):
    """filtre des classes de qos"""
    try:
        matrix_model = initialize.initialize_app(model_file)
        global zones 
        zones = matrix_model.zones
    except Exception, e :
        exit(e)
    qos = initialize.library_store.qos
    # pas de fichier de qos genere si pas de qos dans le modele
    upload_bandwidth = initialize.library_store.upload_bandwidth
    download_bandwidth = initialize.library_store.download_bandwidth
    # s'il n'y a pas de qos de definie on arrete tout
    if upload_bandwidth == "" or download_bandwidth == "":
        sys.exit(0)

    if str(library_store.options['qos']) == '0':
        if qos_file != None:
        # si la qos est desenclenchee dans les options du modele on arrete aussi
            unlink(qos_file)
        sys.exit(0)

    return dict(qos=qos, upload_bandwidth=upload_bandwidth, download_bandwidth=download_bandwidth,
                nb_cards= str(len(qos)) )

def txt_int(qos):
    # FIXME : mettre le num de la zone a la place du nom de la zone
    return "TX_INT_%s=%s" % (str(zone_to_ethnb(qos.zone)), str(int(qos.bandwidth)))

def export_to_qos_file(qos_filename, qos_data):
    """ecrit les regles de qos dans un fichier cible
    qos_data = {
    
    }
    """
    percent_int = "\n".join(list((txt_int(qos) for qos in qos_data['qos'])))
    qos_data['percent_int'] = percent_int
    fh = file(qos_filename, "w")
    fh.write(QOSRULES_TEMPLATE % qos_data)
    # print QOSRULES_TEMPLATE % qos_data
    fh.close()

