#! /usr/bin/env python3
from os.path import join
from collections import defaultdict

from creole.client import CreoleClient

from IPy import IP
from era.noyau.fwobjects import TcpWrapper
from era.noyau.initialize import initialize_app
from era.noyau.models import update_hidden_directive
from era.noyau.objspace.flow.objspace import Service

creole_client = CreoleClient()

master_path = '/etc/eole'
hostallow_fname = 'hosts.allow'
container_path = '/tmp/containers/tcpwrapper'

try:
    #from creole.client import CreoleClient
    #creole_client = CreoleClient()
    mode_conteneur_actif = creole_client.get_creole('mode_conteneur_actif')
    VIRTDISABLED = {'non': True, 'oui': False}.get(mode_conteneur_actif)
except:
    VIRTDISABLED = True

def _get_matrix_model(model_file):
    try:
        matrix_model = initialize_app(model_file)
    except Exception as err:
        print(err)
        print("Erreur lors de la recuperation du matrix_model du fichier modele %s " % model_file)
        exit(1)
    return matrix_model

def get_tcpwrap_directives(model_file, active_file):
    """Return a list of tcpwrappers."""
    def write_tcpwrap(tcpwrappername, rules):
        for src_extremite in d.src_list:
            netmask = src_extremite.netmask
            if d.dest_list[0].extr_type == 'conteneur':
                container_name = d.dest_list[0].container_name
            else:
                # si on n'est pas sur une extremite de type conteneur,
                # on ramene tout dans master
                container_name = 'root'
            for src_ip in src_extremite.ip_list:
                if src_extremite.all_zone:
                    # l'extremite c'est toute la zone. donc c'est 0/0...
                    src_ip = '0'
                    netmask = '0'
                rules.append( ((tcpwrappername, src_ip, netmask), container_name) )

    rules = []
    matrix_model = _get_matrix_model(model_file)
    update_hidden_directive(matrix_model, active_file)
    for d in matrix_model.directive_collector():
        if d.service.is_tcpwrapper_type():
            if d.is_optional():
                if not d.is_active():
                    continue
            # in case a directive is tcpwrapped but in not targetted to the bastion
            # rem : this cas should'nt happen in general
            if d.get_dest_zone().name == "bastion":
                if isinstance(d.service, Service):
                    write_tcpwrap(d.service.tcpwrapper, rules)
                else:
                    for serv in d.service:
                        if serv.is_tcpwrapper_type():
                            write_tcpwrap(serv.tcpwrapper, rules)
    return rules


def test_ip(name, ip):
    """is this an IP or some kind of another species... An alien ?

    :returns: an IPy type (if it returns something,
              else: raises a ValueError)
    """
    try:
        ip = IP(ip)
    except ValueError as err:
        raise ValueError("le service avec le tcpwrapper {0} n'a pas d'IP valide {1}".format(name, ip))
    return ip

def write_rules(rules):
    """writes in the `hosts.allow` file

    :param rules: (tcpwrapper_name, ip) list
    """
    tcpwrappers = defaultdict(list)
    for rule, container_name in rules:
        name, ip, netmask = rule
        # is it a Creole variable ?
        if ip.startswith('%%'):
            try:
                ip = creole_client.get_creole(ip[2:])
            except:
                raise ValueError("variable inconnue : " + str(ip))
        if netmask.startswith('%%'):
            try:
                netmask = creole_client.get_creole(netmask[2:])
            except:
                raise ValueError("variable inconnue : " + str(netmask))
        if isinstance(ip, list):
            for idx, single_ip in enumerate(ip):
                if isinstance(netmask, list):
                    _netmask = netmask[idx]
                else:
                    _netmask = netmask
                single_ipy = test_ip(name, '{0}/{1}'.format(single_ip, _netmask))
                tcpwrappers[container_name].append(TcpWrapper(name=name, ip=single_ipy))
        else:
            ip = test_ip(name, '{0}/{1}'.format(ip, netmask))
            tcpwrappers[container_name].append(TcpWrapper(name=name, ip=ip))

    def write_in_file(fname, tcpwrapper_rules):
        "writes the rules in the file"
        # FIXME : le host.allow va etre ecrase la !!!!!!
        ftcpwrapper = open(fname, 'w')
        ftcpwrapper.write('##### begin: this file is generated by Era - do not edit #####\n')
        for tcpwrapper_rule in tcpwrapper_rules:
            ftcpwrapper.write(str(tcpwrapper_rule)+'\n')
        ftcpwrapper.write('##### end: this file is generated by Era #####\n')
        ftcpwrapper.close()

    for name, value in tcpwrappers.items():
        if VIRTDISABLED or name == 'root':
            write_in_file(join(master_path, hostallow_fname), tcpwrappers[name])
        else:
            write_in_file(join(container_path, name + '.sh'), tcpwrappers[name])


if __name__ == '__main__':
    # TODO should make the parsing of the argv more strong/readable
    import sys
    model_fname = sys.argv[1]
    active_file = sys.argv[2]
    rules = get_tcpwrap_directives(model_fname, active_file)
    write_rules(rules)

