# -*- coding: UTF-8 -*-
import autopath
from era.tests.doctest_xml_compare import xml_compare
from era.noyau.initialize import initialize_app
from era.tests.utils import TempFile
from glob import glob
from lxml import etree

from os.path import isdir, join

SYS_DIR='/usr/share/era/modeles'
REPO_TMPL_DIR=join(autopath.HERE, '..', 'era/templates')
REPO_DIR=join(autopath.HERE, '..', 'era/modeles')

def test_open_save():
    """
    Les règles ne sont pas modifiées si on ré-enregistre les modèles
    """
    MODELES_DIR=None
    if isdir(SYS_DIR):
        MODELES_DIR = SYS_DIR
    elif isdir(REPO_DIR):
        MODELES_DIR = REPO_DIR
    elif isdir(REPO_TMPL_DIR):
        raise Exception('le repertoire de template existe, mais pas les modeles, merci de générer les modeles avec la commande "genmodeles.sh"')
    else:
        raise Exception('impossible de trouver le repertoire de template')

    tp = TempFile()
    newfilename = tp.tmpfname
    for filename in glob(join(MODELES_DIR, '*.xml')):
        a=initialize_app(filename)
        a.save(newfilename)
        fh = open(filename, 'rb')
        xml1 = fh.read()
        fh.close()
        fh = open(newfilename, 'rb')
        xml2 = fh.read()
        fh.close()
        tree1 = etree.fromstring(xml1.strip())
        tree2 = etree.fromstring(xml2.strip())

        assert xml_compare(tree1, tree2)

    tp.clean()

