# -*- coding: utf-8 -*-
"""
teste si une directive est journalisée

attrs=4

-j ULOG --ulog-prefix  "era bla bla"

"""
import autopath
from os.path import join, isfile
from era.tests.hlcompile import high_level_compile as compiler
from era.tests.utils import TempFile
from era.noyau.path import MARKGROUP_FILE
import sys
if sys.version_info[0] >= 3:

    def test_nolog():
        """
        le log n'est pas là quand on lui dit de ne pas être là
        attrs = 0
        """
        tp = TempFile()
        model_file = join(autopath.HERE, "data", "islogged1.xml")
        compiler(model_file, tp.tmpfname)
        buf = tp.read()
        # c'est la ligne de log finale, elle compte pour du beurre
        buf = buf.replace('/sbin/iptables -A ext-bas -m limit --limit 120/min -i eth0 -j ULOG --ulog-prefix "tentative connexion de : "', '')
        assert "ULOG" not in buf
        tp.clean()


    def test_log():
        """
        le log n'est pas là quand on lui dit de ne pas être là

        attrs = 4
        exemples :

        /sbin/iptables -t filter -A ext-bas -m state --state NEW -p tcp --dport 8090 --tcp-flags SYN,RST,ACK SYN -i eth0 -s ip_ssh_eth0/netmask_ssh_eth0 -d adresse_ip_eth0 -j ULOG --ulog-prefix "era ext-bas"
        /sbin/iptables -t filter -A ext-bas -m state --state NEW -p tcp --dport 8090 --tcp-flags SYN,RST,ACK SYN -i eth0 -s ip_ssh_eth0/netmask_ssh_eth0 -d adresse_ip_eth0 -j ACCEPT
        /sbin/iptables -t filter -A ext-bas -m state --state NEW -p tcp --dport 8501 --tcp-flags SYN,RST,ACK SYN -i eth0 -s ip_ssh_eth0/netmask_ssh_eth0 -d adresse_ip_eth0 -j ULOG --ulog-prefix "era ext-bas"
        /sbin/iptables -t filter -A ext-bas -m state --state NEW -p tcp --dport 8501 --tcp-flags SYN,RST,ACK SYN -i eth0 -s ip_ssh_eth0/netmask_ssh_eth0 -d adresse_ip_eth0 -j ACCEPT
        /sbin/iptables -t filter -A ext-bas -m state --state NEW -p tcp --dport 4200 --tcp-flags SYN,RST,ACK SYN -i eth0 -s ip_ssh_eth0/netmask_ssh_eth0 -d adresse_ip_eth0 -j ULOG --ulog-prefix "era ext-bas"
        /sbin/iptables -t filter -A ext-bas -m state --state NEW -p tcp --dport 4200 --tcp-flags SYN,RST,ACK SYN -i eth0 -s ip_ssh_eth0/netmask_ssh_eth0 -d adresse_ip_eth0 -j ACCEPT
        /sbin/iptables -t filter -A ext-bas -m state --state NEW -p icmp --icmp-type echo-request -i eth0 -s ip_ssh_eth0/netmask_ssh_eth0 -d adresse_ip_eth0 -j ULOG --ulog-prefix "era ext-bas"
        /sbin/iptables -t filter -A ext-bas -m state --state NEW -p icmp --icmp-type echo-request -i eth0 -s ip_ssh_eth0/netmask_ssh_eth0 -d adresse_ip_eth0 -j ACCEPT
        /sbin/iptables -t filter -A ext-bas -m state --state NEW -p tcp --dport 22 --tcp-flags SYN,RST,ACK SYN -i eth0 -s ip_ssh_eth0/netmask_ssh_eth0 -d adresse_ip_eth0 -j ULOG --ulog-prefix "era ext-bas"


        """
        tp = TempFile()
        model_file = join(autopath.HERE, "data", "islogged2.xml")
        compiler(model_file, tp.tmpfname)
        buf = tp.read()
        # c'est la ligne de log finale, elle compte pour du beurre
        buf = buf.replace('/sbin/iptables -A ext-bas -m limit --limit 120/min -i eth0 -j LOG --log-prefix "tentative connexion de :', '')
        assert "LOG" in buf
        tp.clean()

    #def test_authenticated_log():
    #    """log pour une directive authentifiée de redirection
    #
    #    si la directive est authentifiée ça ne doit pas logguer
    #    (c'est alors de la responsabilité de
    #    """
    #    # en mode authentifie, le fichier doit exister (il a ete cree)
    #    if not isfile(MARKGROUP_FILE):
    #        fh = file(MARKGROUP_FILE, 'w')
    #        fh.write("")
    #        fh.close()
    #    tp = TempFile()
    #    model_file = join(autopath.HERE, "data", "islogged_auth.xml")
    #    compiler(model_file, tp.tmpfname)
    #    buf = tp.read()
    #    # c'est la ligne de log finale, elle compte pour du beurre
    #    buf = buf.replace('/sbin/iptables -A ext-bas -m limit --limit 120/min -i eth0 -j ULOG --ulog-prefix "tentative connexion de : "', '')
    #    assert "ULOG" not in buf
    #    tp.clean()
