# -*- coding: UTF-8 -*-
"""objets zones (représentation interne)"""

from py.test import raises

import autopath

from xml.dom.minidom import parseString, parse
from era.noyau import domparsers
from era.noyau.fwobjects import Zone
from io import StringIO

## tests du xml

ZONE_NODE = """<zone name="bastion" level="100" ip="127.0.0.1" network="0.0.0.0" netmask="255.255.255.255" interface="lo" />
"""
def test_parse_zone_bastion():
    """parse la zone bastion
    L{era.noyau.domparsers.instantiate_zone_from_dom}
    """
    doc = parseString(ZONE_NODE)
    z = domparsers.instantiate_zone_from_dom(doc.firstChild)
    assert  z.name == "bastion"
    assert  z.level == 100
    assert  z.ip == "127.0.0.1"
    assert  z.network == "0.0.0.0"
    assert  z.netmask == "255.255.255.255"
    assert  z.interface == "lo"

def test_parse_zone():
    """parse une string xml zone
    L{era.noyau.domparsers.instantiate_zone_from_dom}
    """
    Z_BAS_XML = """<zone name="bastion" level="100" ip="127.0.0.1" network="0.0.0.0" netmask="255.255.255.255" interface="lo" />"""
    doc = parseString(Z_BAS_XML)
    z = domparsers.instantiate_zone_from_dom(doc.firstChild)
    assert z.name == "bastion"
    assert z.level == 100
    assert z.ip == "127.0.0.1"
    assert z.network == "0.0.0.0"
    assert z.netmask == "255.255.255.255"
    assert z.interface == "lo"

def test_save_zone():
    """enregistrement en xml d'une zone
    L{era.noyau.fwobjects.Zone.save}
    """
    z_bas = Zone('bastion', 100, '127.0.0.1', network="0.0.0.0", interface='lo')
    fh = StringIO()
    z_bas.save(fh)
    output = fh.getvalue()
    expected = """<zone name="bastion" level="100" ip="127.0.0.1" network="0.0.0.0" netmask="255.255.255.255" interface="lo"/>\n"""
    assert output == expected

## tests de l'objet zone lui-même

def setup_module(module):
    """setup
    """
    zoneA = Zone('zoneA', 30, '127.0.0.1', interface='lo')
    zoneB = Zone('zoneB', 31, '127.0.0.1', interface='lo')
    zoneC = Zone('zoneC', 32, '127.0.0.1', interface='lo')

    module.zones = {'zoneA': zoneA,
             'zoneB': zoneB,
             'zoneC': zoneC
                  }

def test_zone_equal():
    """ L{era.noyau.fwobjects.Zone.__eq__}
    egalité au sens z1 == z2
    """
    zoneA = Zone('zone', 50, '127.0.0.1', interface='lo')
    zoneB = Zone('zone', 50, '127.0.0.1', interface='lo')
    assert zoneA == zoneB

def test_zone_compare():
    """ L{era.noyau.fwobjects.Zone.__cmp__}
    comparaison au sens inferieur (<) ou superieur (>)
    """
    zoneA = Zone('zoneA', 50, '127.0.0.1', interface='lo')
    zoneB = Zone('zoneB', 51, '127.0.0.1', interface='lo')
    assert zoneA < zoneB
    # FIXME tester des comparaisons larges (<= et >=)
