# -*- coding: utf-8 -*-
###########################################################################
# 
# Eole NG  
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  http://www.cecill.info/licences/Licence_CeCILL_V2-fr.html
# eole@ac-dijon.fr 
#  
###########################################################################
"""
    Parseur de fichier mark_group pour les règles de marquage de redirection
"""

from era.noyau.path import MARKGROUP_FILE

marks = []

def write_mark(fname=MARKGROUP_FILE, marks=marks):
    """
        générateur de fichier markgroup.conf
        marks: [(identifiant, marque), ]
    """
    fh = file(fname, 'w+')
    for grp_id, mark in marks:
        fh.write('%s:%s\n'% (grp_id, mark))
    fh.close()
    
def append_mark(grp_id, mark):
    """
        renvoie toutes les marques pour un identifiant donné
        grp_id: identifiant du user_group
    """
    grp_id = str(grp_id)
    mark=str(mark)
    if not group_is_in_markfile(grp_id):
        marks.append((grp_id, mark))
        write_mark()

def get_mark(grp_id, fname=MARKGROUP_FILE):
    mark = None
    fh = file(fname, 'r')
    lines = fh.readlines()
    for line in lines:
        grp, mrk = line.split(':')
        mrk = mrk.strip()
        if grp_id in grp:
            mark = mrk

    fh.close()

    if mark == None : raise Exception("group id not found %s" % str(grp_id))
    return mark
    
def group_is_in_markfile(grp_id, fname=MARKGROUP_FILE):
    """
        parseur de fichier mark_group
        permet de savoir si un group a déjà été inscrit dans le fichier de mark 

    """
    flag = False
    fh = file(fname, 'r')
    lines = fh.readlines()
    for line in lines:
        grp = line.split(':')[0]
        if grp_id in grp:

            flag = True
    fh.close()

    return flag
    

