# -*- coding: UTF-8 -*-
###########################################################################
# 
# Eole NG  
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  http://www.cecill.info/licences/Licence_CeCILL_V2-fr.html
# eole@ac-dijon.fr 
#  
###########################################################################

"""
Module concernant les directives optionnelles
"""

import gtk, gtk.glade
import gobject
from era.noyau.pool import library_store

class LibelleOptionnelDialog:
    """Gère l'activation et la désactivation des libelles (tags) des directives optionnelles
    """

    def __init__(self, glade_file, serv_edit=None):
        """
        glade : l'objet XML glade
        """
        self.glade_file = glade_file
        self.glade = gtk.glade.XML(self.glade_file,"optionnel_dialog", "editeur")
        self.dlg = self.glade.get_widget("optionnel_dialog")

        self.tree_view = self.glade.get_widget('optionnel_treeview')

        handlers = {'on_optionnel_dialog_response' : self.close,
                    # 'on_extremite_listview_dialog_delete_event' : self.stay_alive,
                    # 'on_optionnel_treeview_button_press_event':self.get_selected_clicked,
                    #'on_activate_button_clicked':self.get_selected,
                    #'on_hidden_button_clicked':self.get_hidden_selected,
                   }
        self.glade.signal_autoconnect(handlers)

        store = gtk.ListStore(gobject.TYPE_STRING, gobject.TYPE_BOOLEAN, gobject.TYPE_BOOLEAN)

        renderer = gtk.CellRendererText()
        tog_renderer_active = gtk.CellRendererToggle()
        tog_renderer_hidden = gtk.CellRendererToggle()

        column = gtk.TreeViewColumn(_('ead tag'), renderer, text= 0)
        column.set_expand(True)
        column2 = gtk.TreeViewColumn(_('tag active'), tog_renderer_active, active=1)
        column3 = gtk.TreeViewColumn(_('tag hidden'), tog_renderer_hidden, active=2)
        tog_renderer_active.connect("toggled", self.event_toggle_active, store)
        tog_renderer_hidden.connect("toggled", self.event_toggle_hidden, store)


        self.tree_view.set_model(store)
        self.tree_view.append_column(column)
        self.tree_view.append_column(column2)
        self.tree_view.append_column(column3)

        for tag in library_store.tags.keys():
            store.append([tag,library_store.tags[tag][0],library_store.tags[tag][1]])

    def event_toggle_active(self, cell, path, model):
        model[path][1] = not model[path][1]

    def event_toggle_hidden(self, cell, path, model):
        model[path][2] = not model[path][2]

    def stay_alive(self, *args):
        self.close()
        return True

    def close(self, button, code, *args):
        if code == gtk.RESPONSE_OK:
            # mise à jour de library_store
            self.tree_view.get_model().foreach(self.save_tags,[])
        self.dlg.hide()

    def save_tags(self, model, path, current_iter, data):
        tag = str(model.get_value(current_iter,0))
        actif = model.get_value(current_iter,1)
        hidden = model.get_value(current_iter,2)
        library_store.tags[tag]=(actif,hidden)

    def show_dialog(self):
        self.dlg.show_all()
